/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client;

import com.hub.eso.client.User;
import com.hub.eso.client.components.JComponentStatusPanel;
import com.hub.eso.client.components.JGradientButton;
import com.hub.eso.client.components.JTooltipLabel;
import com.hub.eso.client.components.ScrollBars.ChangelogScrollBar;
import com.hub.eso.client.components.ScrollBars.CustomScrollBar;
import com.hub.eso.client.gui.GUIHelper;
import com.hub.eso.client.gui.ResourceHelper;
import com.hub.eso.client.language.LanguageHandler;
import com.hub.eso.client.threads.AddOnPanelBuilder;
import com.hub.eso.client.threads.CheckComponents;
import com.hub.eso.client.threads.FetchChangelog;
import com.hub.eso.client.threads.InitApplication;
import com.hub.eso.client.threads.UpdateCheck;
import com.hub.eso.client.utils.Autostart;
import com.hub.eso.client.utils.ExceptionHandler;
import com.hub.eso.client.utils.Function;
import com.hub.eso.client.utils.LinkHover;
import com.hub.eso.client.utils.NavigationController;
import com.hub.eso.client.utils.Settings;
import com.hub.eso.client.vars.Colors;
import com.hub.eso.client.vars.Const;
import com.hub.eso.client.web.WebClass;
import com.hub.eso.client.wizard.Wizard;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Locale;
import java.util.concurrent.Callable;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicSliderUI;
import org.apache.commons.lang3.StringUtils;

public class ClientGUI
extends JFrame {
    protected static ClientGUI instance;
    protected final Settings settings;
    protected final WebClass web;
    protected final LanguageHandler lang;
    protected final NavigationController navController;
    protected final User user;
    protected final ClientGUI self = this;
    protected static boolean startMinimized;
    public JLayeredPane mainLayeredPanel;
    public JPanel navPanel;
    public JPanel internetLoadingPanel;
    protected JPanel workingPanel;
    protected JPanel dashboardPanel;
    protected JLabel navDashboardLabel;
    protected JPanel addonsPanel;
    protected JPanel accountPanel;
    public JLabel navAddonsLabel;
    public JLabel navAccountLabel;
    protected JPanel settingsPanel;
    protected JLabel navSettingsLabel;
    protected JPanel informationPanel;
    protected JLabel navInformationLabel;
    protected JPanel checkComponentsPanel;
    protected JPanel dashboardChangelogPanel;
    protected JScrollPane dashboardChangelogScrollPane;
    protected JLabel dashboardChangelogLabel;
    protected JTooltipLabel dashboardChangelogRefreshLabel;
    protected JLabel dashboardTitleLabel;
    protected JLabel dashboardDescriptionLabel;
    protected JPanel dashboardInvalidDataPathPanel;
    protected JLabel dashboardInvalidDataPathLabel;
    protected JPanel dashboardManageAddonsPanel;
    protected JLabel dashboardManageAddonsPanelLabel;
    protected JPanel loginNoticePanel;
    protected JLabel loginNoticeLabel;
    protected JLabel internetStatusLoadingLabel;
    protected JLabel internetStatusTitleLabel;
    protected JLabel internetStatusTextLabel;
    protected JPanel updateBannerPanel;
    protected JLabel updateBannerLabel;
    protected JLabel workingLoadingLabel;
    protected JLabel workingTitleLabel;
    protected JLabel workingTextLabel;
    protected JGradientButton workingButton;
    protected JLabel addonsTitleLabel;
    protected JLabel addonsDescriptionLabel;
    protected JTooltipLabel addonsPanelRefreshLabel;
    protected JPanel addonsItemsPanel;
    protected JScrollPane addonsItemsPanelScrollPanel;
    protected JLabel accountTitleLabel;
    protected JPanel accountGuestPanel;
    protected JPanel accountUserPanel;
    protected JLabel accountLoginTextLabel;
    protected JLabel accountUsernameLabel;
    protected JTextField accountUsernameTextfield;
    protected JLabel accountPasswordLabel;
    protected JPasswordField accountPasswordTextfield;
    protected JLabel accountPasswordFieldCapsLockIndicator;
    protected JLabel accountForgotPasswordLabel;
    protected JGradientButton accountLoginButton;
    protected JSeparator accountMiddleSeparator;
    protected JLabel accountRegisterTextLabel;
    protected JGradientButton accountRegisterButton;
    protected JLabel accountUserTitleLabel;
    protected JLabel accountUserTextLabel;
    protected JLabel accountUserMyAccountTitleLabel;
    protected JLabel accountUserMyAccountEditProfileLabel;
    protected JLabel accountUserMyAccountChangePasswordLabel;
    protected JGradientButton accountUserMyAccountLogoutButton;
    protected JLabel settingsTitleLabel;
    protected JLabel settingsTextLabel;
    protected JLabel settingsESOTitleLabel;
    protected JLabel settingsESODataPathLabel;
    protected JTextField settingsESODataPathTextfield;
    protected JGradientButton settingsESODataPathButton;
    protected JLabel settingsESODataPathDescLabel;
    protected JGradientButton settingsDetectPathsButton;
    protected JLabel settingsClientTitleLabel;
    protected JCheckBox settingsAutostartCheckBox;
    protected JCheckBox settingsMinimizeTrayCheckBox;
    protected JCheckBox settingsShowNotificationsCheckBox;
    protected JLabel settingsCompressionLevelTitle;
    protected JSlider settingsCompressionLevelSlider;
    protected JLabel settingsCompressionLevelValueLabel;
    protected JLabel informationTitleLabel;
    protected JLabel informationTextLabel;
    protected JLabel informationTransferTitleLabel;
    protected JLabel informationTransferredBytesLabel;
    protected JLabel informationTransferredBytesValueLabel;
    protected JLabel informationTransferredTotalLabel;
    protected JLabel informationTransferredTotalValueLabel;
    protected JLabel informationClientTitleLabel;
    protected JLabel informationClientVersionLabel;
    protected JLabel informationClientVersionValueLabel;
    protected JLabel informationClientChangelogTitleLabel;
    protected JTooltipLabel informationClientChangelogRefreshLabel;
    protected JPanel informationClientChangelogPanel;
    protected JScrollPane informationClientChangelogScrollPane;
    protected JLabel informationActionTitleLabel;
    protected JLabel checkComponentsTitleLabel;
    protected JLabel checkComponentsTextLabel;
    protected JPanel checkComponentsItemsPanel;
    protected JGradientButton checkComponentsCloseButton;
    protected JGradientButton informationActionSearchForUpdatesButton;
    protected JGradientButton informationActionOpenLogFolderButton;
    protected JGradientButton informationActionCheckComponentsButton;
    protected JLabel informationCreditsTitleLabel;
    protected JLabel informationCreditsTextLabel;
    protected TrayIcon _trayIcon;
    protected SystemTray _tray;
    protected MenuItem showMenuItem;
    protected MenuItem hideMenuItem;
    protected MenuItem openESODBMenuItem;
    protected MenuItem updateMenuItem;
    protected MenuItem settingsMenuItem;
    protected MenuItem exitItem;
    protected JPanel addonInvalidPathPanel;
    protected JLabel addonInvalidDataPathLabel;

    protected ClientGUI() {
        this.settings = new Settings();
        this.lang = new LanguageHandler();
        this.web = new WebClass(this.lang);
        this.navController = new NavigationController(this);
        if (Function.getShortOSName().equals("mac")) {
            this.settings.setValue("MinimizeToTray", "1");
        }
        if (UpdateCheck.getPendingUpdateStatus()) {
            this.user = null;
            UpdateCheck.runUpdate();
        } else {
            try {
                ResourceHelper.registerFont();
                this.initLanguage();
                this.initComponents();
            }
            catch (Exception e) {
                ExceptionHandler.handle(e);
            }
            this.user = new User(this);
            try {
                this.navController.addElement(this.dashboardPanel, this.navDashboardLabel, "home", "home-disabled");
                this.navController.addElement(this.addonsPanel, this.navAddonsLabel, "list", "list-disabled");
                this.navController.addElement(this.accountPanel, this.navAccountLabel, "user", "user-disabled");
                this.navController.addElement(this.settingsPanel, this.navSettingsLabel, "cogs", "cogs-disabled");
                this.navController.addElement(this.informationPanel, this.navInformationLabel, "database", "database-disabled");
                this.setLanguage(false);
                if (startMinimized && !this.settings.isNewConfig()) {
                    this.hideApp();
                } else {
                    this.showApp();
                }
                if (!this.settings.isNewConfig()) {
                    this.initApp(true);
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    public static synchronized ClientGUI getInstance() {
        if (instance == null) {
            instance = new ClientGUI();
        }
        return instance;
    }

    public static void setStartMinimized(boolean status) {
        startMinimized = status;
    }

    public void setLanguage(boolean forceAddonLoad) {
        try {
            String osName = Function.getShortOSName();
            this.settings.setValue("Lang", this.lang.getLanguage().toString().toLowerCase());
            Locale.setDefault(Locale.ENGLISH);
            this.setLocale(Locale.ENGLISH);
            this.lang.setLanguage(LanguageHandler.Language.en);
            Thread addOnChangelogThread = new Thread(new FetchChangelog(FetchChangelog.Changelog.AddOn, this, this.dashboardChangelogPanel));
            addOnChangelogThread.setName("fetch_addon_changelog");
            addOnChangelogThread.setDaemon(true);
            addOnChangelogThread.start();
            Thread clientChangelogThread = new Thread(new FetchChangelog(FetchChangelog.Changelog.Client, this, this.informationClientChangelogPanel));
            clientChangelogThread.setName("fetch_client_changelog");
            clientChangelogThread.setDaemon(true);
            clientChangelogThread.start();
            if (forceAddonLoad) {
                Thread addonPanelBuilderThread = new Thread(new AddOnPanelBuilder());
                addonPanelBuilderThread.setName("addon_panel_builder_thread");
                addonPanelBuilderThread.setDaemon(true);
                addonPanelBuilderThread.start();
            }
            this.navDashboardLabel.setText(this.lang.getTex("menu_dashboard"));
            this.navAddonsLabel.setText(this.lang.getTex("menu_addons"));
            this.navAccountLabel.setText(this.lang.getTex("menu_my_account"));
            this.navSettingsLabel.setText(this.lang.getTex("menu_settings"));
            this.navInformationLabel.setText(this.lang.getTex("menu_information"));
            this.dashboardChangelogLabel.setText(this.lang.getTex("dashboard_addon_changelog"));
            this.dashboardTitleLabel.setText(this.lang.getTex("menu_dashboard"));
            this.dashboardDescriptionLabel.setText(this.lang.getTex("welcome_text"));
            this.loginNoticeLabel.setText(this.lang.getTex("login_notice"));
            this.internetStatusTitleLabel.setText(this.lang.getTex("inet_no_connection_title"));
            this.internetStatusTextLabel.setText(this.lang.getTex("inet_no_connection_text"));
            this.addonsTitleLabel.setText(this.lang.getTex("menu_addons"));
            this.addonsDescriptionLabel.setText(this.lang.getTex("addons_description_text"));
            this.accountTitleLabel.setText(this.lang.getTex("menu_my_account"));
            this.accountLoginTextLabel.setText(this.lang.getTex("my_account_login_text"));
            this.accountUsernameLabel.setText(this.lang.getTex("my_account_login_username"));
            this.accountPasswordLabel.setText(this.lang.getTex("my_account_login_password"));
            this.accountForgotPasswordLabel.setText(this.lang.getTex("my_account_login_forgot_password"));
            this.accountLoginButton.setText(this.lang.getTex("my_account_login"));
            this.accountRegisterTextLabel.setText(this.lang.getTex("my_account_register_text"));
            this.accountRegisterButton.setText(this.lang.getTex("my_account_register_now"));
            this.accountUserTextLabel.setText(this.lang.getTex("my_account_logged_text"));
            this.accountUserMyAccountTitleLabel.setText(this.lang.getTex("my_account_title"));
            this.accountUserMyAccountEditProfileLabel.setText(this.lang.getTex("my_account_edit_profile"));
            this.accountUserMyAccountChangePasswordLabel.setText(this.lang.getTex("my_account_change_password"));
            this.accountUserMyAccountLogoutButton.setText(this.lang.getTex("my_account_logout"));
            this.settingsTitleLabel.setText(this.lang.getTex("menu_settings"));
            this.settingsTextLabel.setText(this.lang.getTex("settings_description"));
            this.settingsESOTitleLabel.setText(this.lang.getTex("settings_eso_paths"));
            this.settingsESODataPathLabel.setText(this.lang.getTex("settings_data_dir"));
            this.settingsESODataPathButton.setText(this.lang.getTex("global_browse"));
            this.settingsDetectPathsButton.setText(this.lang.getTex("settings_detect_paths"));
            this.settingsClientTitleLabel.setText(this.lang.getTex("settings_client"));
            if (Function.getShortOSName().equals("windows") || Function.getShortOSName().equals("mac")) {
                this.settingsAutostartCheckBox.setText(this.lang.getTex("settings_autostart"));
            }
            this.informationTitleLabel.setText(this.lang.getTex("menu_information"));
            this.settingsCompressionLevelTitle.setText(this.lang.getTex("compression_settings"));
            this.informationTextLabel.setText(this.lang.getTex("information_description"));
            this.informationTransferTitleLabel.setText(this.lang.getTex("information_transferred_data"));
            this.informationTransferredBytesLabel.setText(this.lang.getTex("settings_total_transferred"));
            this.informationTransferredTotalLabel.setText(this.lang.getTex("settings_transferred_data"));
            this.informationClientTitleLabel.setText(this.lang.getTex("settings_client_information"));
            this.informationClientVersionLabel.setText(this.lang.getTex("global_version"));
            this.informationClientChangelogTitleLabel.setText(this.lang.getTex("information_client_changelog_title"));
            this.informationActionTitleLabel.setText(this.lang.getTex("settings_actions"));
            this.informationActionSearchForUpdatesButton.setText(this.lang.getTex("menu_update_check"));
            this.informationActionOpenLogFolderButton.setText(this.lang.getTex("open_log_folder"));
            this.informationActionCheckComponentsButton.setText(this.lang.getTex("check_components"));
            this.informationCreditsTitleLabel.setText(this.lang.getTex("about_the_app"));
            this.informationCreditsTextLabel.setText(this.lang.getTex("about_the_app_text"));
            this.checkComponentsTitleLabel.setText(this.lang.getTex("check_components_title"));
            this.checkComponentsTextLabel.setText(this.lang.getTex("check_components_description"));
            this.checkComponentsCloseButton.setText(this.lang.getTex("global_ok"));
            this.dashboardInvalidDataPathLabel.setText(this.lang.getTex("dashboard_invalid_data_path"));
            this.dashboardManageAddonsPanelLabel.setText(this.lang.getTex("dashboard_manage_addons"));
            this.workingButton.setText(this.lang.getTex("global_ok"));
            this.dashboardChangelogRefreshLabel.setToolTipText(this.lang.getTex("refresh_changelog_tooltip"));
            this.addonsPanelRefreshLabel.setToolTipText(this.lang.getTex("refresh_addon_list_tooltip"));
            this.informationClientChangelogRefreshLabel.setToolTipText(this.lang.getTex("refresh_changelog_tooltip"));
            if (Function.getShortOSName().equals("mac")) {
                this.settingsShowNotificationsCheckBox.setText(this.lang.getTex("settings_show_upload_notifications_osx"));
            } else {
                if (!Function.getShortOSName().equals("mac")) {
                    this.settingsMinimizeTrayCheckBox.setText(this.lang.getTex("settings_minimize_system_tray"));
                }
                this.settingsShowNotificationsCheckBox.setText(this.lang.getTex("settings_show_upload_notifications"));
            }
            if (this.addonInvalidDataPathLabel != null) {
                this.addonInvalidDataPathLabel.setText(this.lang.getTex("dashboard_invalid_data_path"));
                this.addonsItemsPanel.updateUI();
            }
            if (SystemTray.isSupported()) {
                this.showMenuItem.setLabel(this.lang.getTex("menu_show"));
                this.hideMenuItem.setLabel(this.lang.getTex("menu_hide"));
                this.openESODBMenuItem.setLabel(this.lang.getTex("menu_open_website"));
                this.updateMenuItem.setLabel(this.lang.getTex("menu_update_check"));
                this.settingsMenuItem.setLabel(this.lang.getTex("menu_settings"));
                this.exitItem.setLabel(this.lang.getTex("menu_close_app"));
            }
            this.setAccountName();
            this.loadData();
            if (this.checkComponentsPanel.isVisible()) {
                this.loadCheckComponentsData();
            }
            String osDataDirText = switch (osName) {
                case "windows" -> this.lang.getTex("settings_data_dir_default_windows");
                case "mac" -> this.lang.getTex("settings_data_dir_default_mac");
                case "linux" -> this.lang.getTex("settings_data_dir_default_linux");
                default -> "";
            };
            this.settingsESODataPathDescLabel.setText(osDataDirText);
            if (this.loginNoticePanel.isVisible()) {
                if (this.updateBannerPanel.isVisible()) {
                    this.mainLayeredPanel.moveToBack(this.loginNoticePanel);
                    this.mainLayeredPanel.moveToFront(this.updateBannerPanel);
                } else {
                    this.mainLayeredPanel.moveToBack(this.updateBannerPanel);
                    this.mainLayeredPanel.moveToFront(this.loginNoticePanel);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public void setDataPath(String path, boolean writeToConfig) {
        try {
            this.settingsESODataPathTextfield.setText(path);
            String dataPath = path + Const.ESO_SV_LIVE_DIR;
            this.self.setInvalidDataPathVisible(!Function.dirExists(dataPath));
            if (writeToConfig) {
                this.settings.setValue("ESODataDir", path);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public void detectDataPath(boolean workingPanel) {
        try {
            String esoDataDir;
            if (workingPanel) {
                this.setWorkingPanel(true, this.lang.getTex("detect_path_title"), this.lang.getTex("detect_path_text"), "loading.gif", true, null);
            }
            if (!(esoDataDir = Function.getESODataDir()).isEmpty()) {
                String oldPath = this.settingsESODataPathTextfield.getText();
                this.setDataPath(esoDataDir, true);
                if (!oldPath.equals(esoDataDir)) {
                    Thread addonPanelBuilderThread = new Thread(new AddOnPanelBuilder());
                    addonPanelBuilderThread.setName("addon_panel_builder_thread");
                    addonPanelBuilderThread.setDaemon(true);
                    addonPanelBuilderThread.start();
                }
                if (workingPanel) {
                    this.setWorkingPanel(true, this.lang.getTex("detect_path_title_success"), this.lang.getTex("detect_path_text_success"), "check.png", true, null);
                }
            } else if (workingPanel) {
                this.setWorkingPanel(true, this.lang.getTex("detect_path_title_fail"), this.lang.getTex("detect_path_text_fail"), "times.png", true, null);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public void initApp(boolean showDashboard) {
        try {
            Thread addOnStatusThread = new Thread(new InitApplication(this, showDashboard));
            addOnStatusThread.setName("init_application");
            addOnStatusThread.setDaemon(true);
            addOnStatusThread.start();
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public synchronized void setAccountName() {
        try {
            this.accountUserTitleLabel.setText(StringUtils.replace(this.lang.getTex("my_account_welcome"), "%username%", this.user.getUserName()));
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public synchronized void setInternetStatusPanel(boolean visible, String title, String text) {
        try {
            if (visible) {
                this.navPanel.setVisible(false);
                this.navController.getActiveElement().setVisible(false);
            } else {
                this.navPanel.setVisible(true);
                this.navController.getActiveElement().setVisible(true);
            }
            this.internetStatusTitleLabel.setText(title);
            this.internetStatusTextLabel.setText(text);
            this.internetLoadingPanel.setVisible(visible);
            if (visible) {
                this.mainLayeredPanel.moveToFront(this.internetLoadingPanel);
            } else {
                this.mainLayeredPanel.moveToBack(this.internetLoadingPanel);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public synchronized void setWorkingPanel(boolean visible, String title, String text, String iconPath, boolean showBtn, final Callable<?> customBtnCallback) {
        try {
            if (visible) {
                this.navPanel.setVisible(false);
                this.navController.getActiveElement().setVisible(false);
                this.workingTitleLabel.setText(title);
                this.workingTextLabel.setText(text);
                this.workingButton.setVisible(showBtn);
                ResourceHelper.setComponentIcon(this.workingLoadingLabel, iconPath, 42, 42);
                if (showBtn && customBtnCallback != null) {
                    this.workingButton.addMouseListener(new MouseAdapter(this){

                        @Override
                        public void mouseReleased(MouseEvent evt) {
                            try {
                                customBtnCallback.call();
                            }
                            catch (Exception e) {
                                ExceptionHandler.handle(e);
                            }
                        }
                    });
                } else if (showBtn) {
                    this.workingButton.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseReleased(MouseEvent evt) {
                            ClientGUI.this.self.setWorkingPanel(false, "", "", "", false, null);
                        }
                    });
                } else {
                    MouseListener[] listeners;
                    for (MouseListener listener : listeners = this.workingButton.getMouseListeners()) {
                        this.workingButton.removeMouseListener(listener);
                    }
                }
            } else {
                this.navPanel.setVisible(true);
                this.navController.getActiveElement().setVisible(true);
            }
            this.workingPanel.setVisible(visible);
            if (visible) {
                this.mainLayeredPanel.moveToFront(this.workingPanel);
            } else {
                this.mainLayeredPanel.moveToBack(this.workingPanel);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public synchronized void setLoginNoticePanel(boolean visible) {
        try {
            this.loginNoticePanel.setVisible(visible);
            if (visible) {
                if (this.updateBannerPanel.isVisible()) {
                    this.mainLayeredPanel.moveToFront(this.updateBannerPanel);
                    this.mainLayeredPanel.moveToBack(this.loginNoticePanel);
                } else {
                    this.mainLayeredPanel.moveToFront(this.loginNoticePanel);
                    this.mainLayeredPanel.moveToBack(this.updateBannerPanel);
                }
            } else if (this.updateBannerPanel.isVisible()) {
                this.mainLayeredPanel.moveToBack(this.navController.getActiveElement());
                this.mainLayeredPanel.moveToFront(this.updateBannerPanel);
            } else {
                this.mainLayeredPanel.moveToFront(this.navController.getActiveElement());
                this.mainLayeredPanel.moveToBack(this.updateBannerPanel);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public synchronized void setTransferredFiles(String text) {
        this.informationTransferredTotalValueLabel.setText(text);
    }

    public synchronized void setTransferredBytes(String text) {
        this.informationTransferredBytesValueLabel.setText(text);
    }

    public synchronized void showDashboardPanel() {
        try {
            this.dashboardPanel.setVisible(true);
            this.mainLayeredPanel.moveToFront(this.dashboardPanel);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public synchronized void showUpdateBanner(String version) {
        try {
            this.updateBannerLabel.setText(StringUtils.replace(this.lang.getTex("update_banner_text"), "%version%", version));
            this.updateBannerPanel.setVisible(true);
            this.mainLayeredPanel.moveToFront(this.updateBannerPanel);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public synchronized void showNotification(String title, String text) {
        try {
            if (this.settingsShowNotificationsCheckBox.isSelected()) {
                if (Function.getShortOSName().equals("mac")) {
                    String osxNotificationWrapper = Function.getOsxNotificationWrapperPath();
                    if (Function.fileExists(osxNotificationWrapper)) {
                        Runtime.getRuntime().exec(new String[]{osxNotificationWrapper, "-identifier", "com.hub.eso.client", "-title", title, "-subtitle", "", "-informativeText", text});
                    }
                } else {
                    this._trayIcon.displayMessage(title, text, TrayIcon.MessageType.NONE);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public synchronized WebClass getWebClass() {
        return this.web;
    }

    public synchronized LanguageHandler getLanguageHandler() {
        return this.lang;
    }

    public synchronized NavigationController getNavigationController() {
        return this.navController;
    }

    public synchronized Settings getSettings() {
        return this.settings;
    }

    public synchronized User getUser() {
        return this.user;
    }

    public synchronized JTextField getUserNameField() {
        return this.accountUsernameTextfield;
    }

    public synchronized JPasswordField getUserPasswordField() {
        return this.accountPasswordTextfield;
    }

    public synchronized void showAccountPanel(User.UserLoginState state) {
        try {
            if (state == User.UserLoginState.LOGGED_IN) {
                this.accountGuestPanel.setVisible(false);
                this.accountUserPanel.setVisible(true);
            } else {
                this.accountGuestPanel.setVisible(true);
                this.accountUserPanel.setVisible(false);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public synchronized JPanel getAddonsItemsPanel() {
        return this.addonsItemsPanel;
    }

    public synchronized JPanel getCheckComponentsItemsPanel() {
        return this.checkComponentsItemsPanel;
    }

    public void hideCheckComponentsPanel() {
        try {
            this.self.checkComponentsPanel.setVisible(false);
            this.self.mainLayeredPanel.moveToBack(this.self.checkComponentsPanel);
            this.navController.getActiveElement().setVisible(true);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public synchronized void addCheckComponentPanel(JComponentStatusPanel panel) {
        this.checkComponentsItemsPanel.add(panel);
    }

    public synchronized void setDashboardChangelogRefreshLabelEnabled(boolean status) {
        this.dashboardChangelogRefreshLabel.setEnabled(status);
    }

    public synchronized void setInformationClientChangelogRefreshLabelEnabled(boolean status) {
        this.informationClientChangelogRefreshLabel.setEnabled(status);
    }

    public synchronized void setAddonsPanelRefreshLabelEnabled(boolean status) {
        this.addonsPanelRefreshLabel.setEnabled(status);
    }

    protected void initLanguage() {
        try {
            this.lang.setLanguage(LanguageHandler.Language.en);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void initComponents() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            Image appIcon = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/eso_hub_logo.png"));
            this.setDefaultCloseOperation(0);
            if (Function.getShortOSName().equals("windows")) {
                this.setSize(new Dimension(874, 614));
            } else {
                this.setSize(new Dimension(860, 600));
            }
            this.setName("MainForm");
            this.setTitle("ESO-Hub Client");
            this.setResizable(false);
            this.setFont(new Font("Roboto", 0, 12));
            this.setLocationRelativeTo(null);
            this.setIconImage(appIcon);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (Function.getShortOSName().equals("mac")) {
                        ClientGUI.this.self.hideApp();
                    } else if (!Function.getShortOSName().equals("mac") && ClientGUI.this.self.settingsMinimizeTrayCheckBox.isSelected()) {
                        ClientGUI.this.self.hideApp();
                    } else {
                        System.exit(0);
                    }
                }

                @Override
                public void windowIconified(WindowEvent e) {
                    if (Function.getShortOSName().equals("mac")) {
                        ClientGUI.this.self.hideApp();
                    }
                }
            });
            this.initGlobalComponents();
            this.initDashboardComponents();
            this.initAddonComponents();
            this.initAccountComponents();
            this.initSettingsComponents();
            this.initInformationComponents();
            this.initCheckComponents();
            this.createSysTray();
            if (this.settings.isNewConfig()) {
                new Wizard(this);
            } else {
                this.mainLayeredPanel.moveToFront(this.internetLoadingPanel);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void initGlobalComponents() {
        try {
            this.mainLayeredPanel = new JLayeredPane();
            this.mainLayeredPanel.setDoubleBuffered(false);
            this.mainLayeredPanel.setBounds(0, 0, 860, 600);
            this.internetLoadingPanel = GUIHelper.getPanel(Colors.PANEL_COLOR, null, 0, 0, 860, 600);
            this.workingPanel = GUIHelper.getPanel(Colors.PANEL_COLOR, null, 0, 0, 860, 600);
            this.workingPanel.setVisible(false);
            this.navPanel = GUIHelper.getPanel(Colors.NAVIGATION_COLOR, null, 0, 0, 114, 600);
            this.navPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Colors.BORDER_COLOR));
            this.dashboardPanel = GUIHelper.getPanel(Colors.PANEL_COLOR, null, 114, 0, 747, 600);
            this.dashboardPanel.setVisible(false);
            this.addonsPanel = GUIHelper.getPanel(Colors.PANEL_COLOR, null, 114, 0, 747, 600);
            this.addonsPanel.setVisible(false);
            this.accountPanel = GUIHelper.getPanel(Colors.PANEL_COLOR, null, 114, 0, 747, 600);
            this.accountPanel.setVisible(false);
            this.settingsPanel = GUIHelper.getPanel(Colors.PANEL_COLOR, null, 114, 0, 747, 600);
            this.settingsPanel.setVisible(false);
            this.settingsPanel.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    ClientGUI.this.self.setDataPath(ClientGUI.this.self.settingsESODataPathTextfield.getText(), true);
                    Thread addonPanelBuilderThread = new Thread(new AddOnPanelBuilder());
                    addonPanelBuilderThread.setName("addon_panel_builder_thread");
                    addonPanelBuilderThread.setDaemon(true);
                    addonPanelBuilderThread.start();
                }
            });
            this.informationPanel = GUIHelper.getPanel(Colors.PANEL_COLOR, null, 114, 0, 747, 600);
            this.informationPanel.setVisible(false);
            this.checkComponentsPanel = GUIHelper.getPanel(Colors.PANEL_COLOR, null, 114, 0, 747, 600);
            this.checkComponentsPanel.setVisible(false);
            this.loginNoticePanel = GUIHelper.getPanel(Colors.NOTIFICATION_PANEL_COLOR, null, 114, 0, 750, 35);
            this.loginNoticePanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Colors.BORDER_COLOR));
            this.loginNoticePanel.setCursor(new Cursor(12));
            this.loginNoticePanel.setVisible(false);
            this.loginNoticePanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    ClientGUI.this.self.navController.setActiveElement(ClientGUI.this.self.navAccountLabel.getName());
                }
            });
            this.loginNoticeLabel = GUIHelper.getLabel("[login_notice]", 1, 13, Colors.BLACK_TEXT_COLOR);
            this.loginNoticeLabel.setBounds(4, 0, 740, 35);
            ResourceHelper.setComponentIcon(this.loginNoticeLabel, "plug-black.png", 16, 16);
            this.internetStatusLoadingLabel = GUIHelper.getLabel();
            this.internetStatusLoadingLabel.setBounds(180, 140, 42, 42);
            this.internetStatusLoadingLabel.setVerticalTextPosition(3);
            ResourceHelper.setComponentIcon(this.internetStatusLoadingLabel, "loading.gif", 42, 42);
            this.internetStatusTitleLabel = GUIHelper.getTitleLabel("[inet_no_connection_title]", 230, 136, 400, 26);
            this.internetStatusTitleLabel.setVerticalAlignment(1);
            this.internetStatusTextLabel = GUIHelper.getLabel("[inet_no_connection_title]");
            this.internetStatusTextLabel.setBounds(230, 168, 400, 80);
            this.internetStatusTextLabel.setVerticalAlignment(1);
            this.updateBannerPanel = GUIHelper.getPanel(Colors.UPDATE_BANNER_PANEL_COLOR, null, 114, 0, 750, 35);
            this.updateBannerPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Colors.BORDER_COLOR));
            this.updateBannerPanel.setCursor(new Cursor(12));
            this.updateBannerPanel.setVisible(false);
            this.updateBannerPanel.addMouseListener(new MouseAdapter(this){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    UpdateCheck.runUpdate();
                }
            });
            this.updateBannerLabel = GUIHelper.getLabel("[login_notice]", 1, 13, Colors.TEXT_COLOR_REGULAR);
            this.updateBannerLabel.setBounds(4, 0, 740, 35);
            ResourceHelper.setComponentIcon(this.updateBannerLabel, "download.png", 16, 16);
            this.workingLoadingLabel = GUIHelper.getLabel();
            this.workingLoadingLabel.setBounds(180, 140, 42, 42);
            this.workingLoadingLabel.setVerticalTextPosition(3);
            ResourceHelper.setComponentIcon(this.workingLoadingLabel, "loading.gif", 42, 42);
            this.workingTitleLabel = GUIHelper.getTitleLabel("[inet_no_connection_title]", 230, 136, 500, 26);
            this.workingTitleLabel.setVerticalAlignment(1);
            this.workingTextLabel = GUIHelper.getLabel("[inet_no_connection_text]");
            this.workingTextLabel.setBounds(230, 168, 500, 94);
            this.workingTextLabel.setVerticalAlignment(1);
            this.workingButton = GUIHelper.getGradientButton("[global_ok]");
            this.workingButton.setBounds(336, 268, 160, 38);
            this.workingButton.setVisible(false);
            ResourceHelper.setComponentIcon(this.workingButton, "check.png", 17, 17);
            this.navDashboardLabel = GUIHelper.getLabel("[menu_dashboard]", 1, 13);
            this.navDashboardLabel.setName("nav_dashboard");
            this.navDashboardLabel.setCursor(new Cursor(12));
            this.navDashboardLabel.setHorizontalAlignment(0);
            this.navDashboardLabel.setHorizontalTextPosition(0);
            this.navDashboardLabel.setVerticalTextPosition(3);
            this.navDashboardLabel.setVerifyInputWhenFocusTarget(false);
            this.navDashboardLabel.setIconTextGap(5);
            this.navDashboardLabel.setBounds(0, 0, 113, 80);
            this.navDashboardLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    ClientGUI.this.self.navController.setActiveElement(((JLabel)evt.getSource()).getName());
                }
            });
            ResourceHelper.setComponentIcon(this.navDashboardLabel, "home.png", 48, 48);
            this.navAddonsLabel = GUIHelper.getLabel("[menu_addons]", 1, 13, Colors.INACTIVE_TEXT_COLOR);
            this.navAddonsLabel.setName("nav_addons");
            this.navAddonsLabel.setCursor(new Cursor(12));
            this.navAddonsLabel.setHorizontalAlignment(0);
            this.navAddonsLabel.setHorizontalTextPosition(0);
            this.navAddonsLabel.setVerticalTextPosition(3);
            this.navAddonsLabel.setVerifyInputWhenFocusTarget(false);
            this.navAddonsLabel.setIconTextGap(5);
            this.navAddonsLabel.setBounds(0, 87, 113, 80);
            this.navAddonsLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    ClientGUI.this.self.navController.setActiveElement(((JLabel)evt.getSource()).getName());
                }
            });
            ResourceHelper.setComponentIcon(this.navAddonsLabel, "list-disabled.png", 48, 48);
            this.navAccountLabel = GUIHelper.getLabel("[menu_my_account]", 1, 13, Colors.INACTIVE_TEXT_COLOR);
            this.navAccountLabel.setName("nav_account");
            this.navAccountLabel.setCursor(new Cursor(12));
            this.navAccountLabel.setHorizontalAlignment(0);
            this.navAccountLabel.setHorizontalTextPosition(0);
            this.navAccountLabel.setVerticalTextPosition(3);
            this.navAccountLabel.setVerifyInputWhenFocusTarget(false);
            this.navAccountLabel.setIconTextGap(5);
            this.navAccountLabel.setBounds(0, 174, 113, 80);
            this.navAccountLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    ClientGUI.this.self.navController.setActiveElement(((JLabel)evt.getSource()).getName());
                }
            });
            ResourceHelper.setComponentIcon(this.navAccountLabel, "user-disabled.png", 48, 48);
            this.navSettingsLabel = GUIHelper.getLabel("[menu_settings]", 1, 13, Colors.INACTIVE_TEXT_COLOR);
            this.navSettingsLabel.setName("nav_settings");
            this.navSettingsLabel.setCursor(new Cursor(12));
            this.navSettingsLabel.setHorizontalAlignment(0);
            this.navSettingsLabel.setHorizontalTextPosition(0);
            this.navSettingsLabel.setVerticalTextPosition(3);
            this.navSettingsLabel.setVerifyInputWhenFocusTarget(false);
            this.navSettingsLabel.setIconTextGap(5);
            this.navSettingsLabel.setBounds(0, 261, 113, 80);
            this.navSettingsLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    ClientGUI.this.self.navController.setActiveElement(((JLabel)evt.getSource()).getName());
                }
            });
            ResourceHelper.setComponentIcon(this.navSettingsLabel, "cogs-disabled.png", 48, 48);
            this.navInformationLabel = GUIHelper.getLabel("[menu_information]", 1, 13, Colors.INACTIVE_TEXT_COLOR);
            this.navInformationLabel.setName("nav_information");
            this.navInformationLabel.setCursor(new Cursor(12));
            this.navInformationLabel.setHorizontalAlignment(0);
            this.navInformationLabel.setHorizontalTextPosition(0);
            this.navInformationLabel.setVerticalTextPosition(3);
            this.navInformationLabel.setVerifyInputWhenFocusTarget(false);
            this.navInformationLabel.setIconTextGap(5);
            this.navInformationLabel.setBounds(0, 348, 113, 80);
            this.navInformationLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    ClientGUI.this.self.navController.setActiveElement(((JLabel)evt.getSource()).getName());
                }
            });
            ResourceHelper.setComponentIcon(this.navInformationLabel, "database-disabled.png", 48, 48);
            this.mainLayeredPanel.add(this.navPanel);
            this.mainLayeredPanel.add(this.internetLoadingPanel);
            this.mainLayeredPanel.add(this.workingPanel);
            this.mainLayeredPanel.add(this.dashboardPanel);
            this.mainLayeredPanel.add(this.addonsPanel);
            this.mainLayeredPanel.add(this.accountPanel);
            this.mainLayeredPanel.add(this.settingsPanel);
            this.mainLayeredPanel.add(this.informationPanel);
            this.mainLayeredPanel.add(this.checkComponentsPanel);
            this.mainLayeredPanel.add(this.loginNoticePanel);
            this.mainLayeredPanel.add(this.updateBannerPanel);
            this.loginNoticePanel.add(this.loginNoticeLabel);
            this.updateBannerPanel.add(this.updateBannerLabel);
            this.navPanel.add(this.navDashboardLabel);
            this.navPanel.add(this.navAddonsLabel);
            this.navPanel.add(this.navAccountLabel);
            this.navPanel.add(this.navSettingsLabel);
            this.navPanel.add(this.navInformationLabel);
            this.internetLoadingPanel.add(this.internetStatusLoadingLabel);
            this.internetLoadingPanel.add(this.internetStatusTitleLabel);
            this.internetLoadingPanel.add(this.internetStatusTextLabel);
            this.workingPanel.add(this.workingLoadingLabel);
            this.workingPanel.add(this.workingTitleLabel);
            this.workingPanel.add(this.workingTextLabel);
            this.workingPanel.add(this.workingButton);
            this.add(this.mainLayeredPanel);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void initDashboardComponents() {
        try {
            this.dashboardChangelogLabel = GUIHelper.getLabel("[dashboard_addon_changelog]", 1);
            this.dashboardChangelogLabel.setBounds(7, 170, 600, 20);
            ResourceHelper.setComponentIcon(this.dashboardChangelogLabel, "bars.png", 20, 20);
            this.dashboardChangelogRefreshLabel = GUIHelper.getTooltipLabel("", 0, 14, Colors.ACTIVE_TEXT_COLOR);
            this.dashboardChangelogRefreshLabel.setBounds(716, 171, 16, 16);
            this.dashboardChangelogRefreshLabel.setCursor(new Cursor(12));
            this.dashboardChangelogRefreshLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    Thread addOnChangelogThread = new Thread(new FetchChangelog(FetchChangelog.Changelog.AddOn, ClientGUI.this.self, ClientGUI.this.self.dashboardChangelogPanel));
                    addOnChangelogThread.setName("fetch_addon_changelog");
                    addOnChangelogThread.setDaemon(true);
                    addOnChangelogThread.start();
                }
            });
            ResourceHelper.setComponentIcon(this.dashboardChangelogRefreshLabel, "refresh.png", 16, 16);
            this.dashboardChangelogPanel = GUIHelper.getScrollPanel(Colors.NAVIGATION_COLOR, 0, 0, 733, 246);
            this.dashboardChangelogPanel.setLayout(new BoxLayout(this.dashboardChangelogPanel, 1));
            this.dashboardChangelogScrollPane = new JScrollPane(this.dashboardChangelogPanel);
            this.dashboardChangelogScrollPane.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Colors.BORDER_COLOR));
            this.dashboardChangelogScrollPane.setBounds(5, 200, 733, 370);
            this.dashboardChangelogScrollPane.setHorizontalScrollBarPolicy(31);
            this.dashboardChangelogScrollPane.getVerticalScrollBar().setUnitIncrement(8);
            this.dashboardChangelogScrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(16, 0));
            this.dashboardChangelogScrollPane.getVerticalScrollBar().setUI(new ChangelogScrollBar());
            this.dashboardTitleLabel = GUIHelper.getTitleLabel("[menu_dashboard]", 7, 7, 728, 28);
            this.dashboardDescriptionLabel = GUIHelper.getLabel("[welcome_text]", Colors.TEXT_COLOR_REGULAR);
            this.dashboardDescriptionLabel.setBounds(7, 6, 728, 100);
            this.dashboardInvalidDataPathPanel = GUIHelper.getPanel(Colors.NOTIFICATION_PANEL_COLOR, null, 7, 80, 728, 78);
            this.dashboardInvalidDataPathPanel.setVisible(false);
            this.dashboardInvalidDataPathPanel.setOpaque(true);
            this.dashboardInvalidDataPathPanel.setCursor(new Cursor(12));
            this.dashboardInvalidDataPathPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    ClientGUI.this.self.navController.setActiveElement(ClientGUI.this.self.navSettingsLabel.getName());
                }
            });
            this.dashboardInvalidDataPathLabel = GUIHelper.getLabel("[dashboard_invalid_data_path]", 0, 13, Colors.BLACK_TEXT_COLOR);
            this.dashboardInvalidDataPathLabel.setBounds(6, 6, 600, 70);
            this.dashboardInvalidDataPathLabel.setVerticalAlignment(0);
            this.dashboardInvalidDataPathLabel.setHorizontalAlignment(0);
            this.dashboardInvalidDataPathLabel.setIconTextGap(10);
            ResourceHelper.setComponentIcon(this.dashboardInvalidDataPathLabel, "exclamation-triangle.png", 38, 38);
            this.dashboardManageAddonsPanel = GUIHelper.getPanel(Colors.INPUT_BACKGROUND_COLOR, null, 7, 80, 728, 78);
            this.dashboardManageAddonsPanel.setVisible(true);
            this.dashboardManageAddonsPanel.setOpaque(true);
            this.dashboardManageAddonsPanel.setCursor(new Cursor(12));
            this.dashboardManageAddonsPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    ClientGUI.this.self.navController.setActiveElement(ClientGUI.this.self.navAddonsLabel.getName());
                }
            });
            this.dashboardManageAddonsPanelLabel = GUIHelper.getLabel("[dashboard_manage_addons]", 1, 13);
            this.dashboardManageAddonsPanelLabel.setBounds(6, 6, 600, 70);
            this.dashboardManageAddonsPanelLabel.setVerticalAlignment(0);
            this.dashboardManageAddonsPanelLabel.setHorizontalAlignment(0);
            this.dashboardManageAddonsPanelLabel.setIconTextGap(10);
            ResourceHelper.setComponentIcon(this.dashboardManageAddonsPanelLabel, "cogs.png", 38, 38);
            this.dashboardPanel.add(this.dashboardChangelogRefreshLabel);
            this.dashboardPanel.add(this.dashboardChangelogLabel);
            this.dashboardPanel.add(this.dashboardTitleLabel);
            this.dashboardPanel.add(this.dashboardDescriptionLabel);
            this.dashboardPanel.add(this.dashboardChangelogScrollPane);
            this.dashboardPanel.add(this.dashboardInvalidDataPathPanel);
            this.dashboardInvalidDataPathPanel.add(this.dashboardInvalidDataPathLabel);
            this.dashboardPanel.add(this.dashboardManageAddonsPanel);
            this.dashboardManageAddonsPanel.add(this.dashboardManageAddonsPanelLabel);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void initAddonComponents() {
        try {
            this.addonsTitleLabel = GUIHelper.getTitleLabel("[menu_addons]", 7, 7, 728, 28);
            this.addonsDescriptionLabel = GUIHelper.getLabel("[addons_description_text]", Colors.TEXT_COLOR_REGULAR);
            this.addonsDescriptionLabel.setBounds(7, 36, 600, 25);
            this.addonsPanelRefreshLabel = GUIHelper.getTooltipLabel("", 0, 14, Colors.ACTIVE_TEXT_COLOR);
            this.addonsPanelRefreshLabel.setBounds(723, 42, 16, 16);
            this.addonsPanelRefreshLabel.setCursor(new Cursor(12));
            this.addonsPanelRefreshLabel.addMouseListener(new MouseAdapter(this){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    Thread addonPanelBuilderThread = new Thread(new AddOnPanelBuilder());
                    addonPanelBuilderThread.setName("addon_panel_builder_thread");
                    addonPanelBuilderThread.setDaemon(true);
                    addonPanelBuilderThread.start();
                }
            });
            ResourceHelper.setComponentIcon(this.addonsPanelRefreshLabel, "refresh.png", 16, 16);
            this.addonsItemsPanel = GUIHelper.getScrollPanel(Colors.PANEL_COLOR, 7, 7, 712, 530);
            this.addonsItemsPanel.setLayout(new BoxLayout(this.addonsItemsPanel, 1));
            this.addonsItemsPanelScrollPanel = new JScrollPane(this.addonsItemsPanel);
            this.addonsItemsPanelScrollPanel.setBounds(7, 70, 733, 496);
            this.addonsItemsPanelScrollPanel.setBorder(null);
            this.addonsItemsPanelScrollPanel.setVerticalScrollBarPolicy(22);
            this.addonsItemsPanelScrollPanel.setHorizontalScrollBarPolicy(31);
            this.addonsItemsPanelScrollPanel.getVerticalScrollBar().setUnitIncrement(8);
            this.addonsItemsPanelScrollPanel.getVerticalScrollBar().setPreferredSize(new Dimension(16, 0));
            this.addonsItemsPanelScrollPanel.getVerticalScrollBar().setUI(new CustomScrollBar());
            this.addonsPanel.add(this.addonsPanelRefreshLabel);
            this.addonsPanel.add(this.addonsTitleLabel);
            this.addonsPanel.add(this.addonsDescriptionLabel);
            this.addonsPanel.add(this.addonsItemsPanelScrollPanel);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void initAccountComponents() {
        try {
            this.accountPasswordTextfield = new JPasswordField();
            this.accountMiddleSeparator = new JSeparator();
            this.accountTitleLabel = GUIHelper.getTitleLabel("[menu_account]", 7, 7, 728, 28);
            this.accountGuestPanel = GUIHelper.getPanel(Colors.PANEL_COLOR, null, 0, 38, 747, 562);
            this.accountGuestPanel.setVisible(true);
            this.accountUserPanel = GUIHelper.getPanel(Colors.PANEL_COLOR, null, 0, 38, 747, 562);
            this.accountUserPanel.setVisible(false);
            this.accountLoginTextLabel = GUIHelper.getLabel("[my_account_login_text]", Colors.TEXT_COLOR_REGULAR);
            this.accountLoginTextLabel.setBounds(7, 5, 373, 50);
            this.accountLoginTextLabel.setVerticalAlignment(1);
            this.accountUsernameLabel = GUIHelper.getLabel("[my_account_login_username]", 1);
            this.accountUsernameLabel.setBounds(9, 39, 373, 16);
            this.accountUsernameLabel.setVerticalAlignment(1);
            this.accountUsernameTextfield = GUIHelper.getTextField();
            this.accountUsernameTextfield.setBounds(7, 60, 368, 29);
            this.accountUsernameTextfield.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClientGUI.this.self.user.login();
                }
            });
            this.accountPasswordLabel = GUIHelper.getLabel("[my_account_login_password]", 1);
            this.accountPasswordLabel.setBounds(9, 99, 373, 16);
            this.accountPasswordLabel.setVerticalAlignment(1);
            this.accountPasswordTextfield.setDoubleBuffered(false);
            this.accountPasswordTextfield.setFont(new Font("Roboto", 0, 16));
            this.accountPasswordTextfield.setForeground(Colors.ACTIVE_TEXT_COLOR);
            this.accountPasswordTextfield.setBackground(Colors.INPUT_BACKGROUND_COLOR);
            this.accountPasswordTextfield.setBounds(7, 120, 368, 29);
            this.accountPasswordTextfield.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Colors.BORDER_INPUT_COLOR), new EmptyBorder(2, 4, 2, 4)));
            this.accountPasswordTextfield.setCaretColor(Colors.ACTIVE_TEXT_COLOR);
            this.accountPasswordTextfield.setEchoChar('\u2022');
            this.accountPasswordTextfield.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClientGUI.this.self.user.login();
                }
            });
            this.accountPasswordFieldCapsLockIndicator = GUIHelper.getLabel();
            this.accountPasswordFieldCapsLockIndicator.setBounds(342, 4, 21, 21);
            this.accountPasswordFieldCapsLockIndicator.setVisible(false);
            ResourceHelper.setComponentIcon(this.accountPasswordFieldCapsLockIndicator, "caret-square-o-up.png", 21, 21);
            if (!Function.getShortOSName().equals("mac")) {
                this.self.toggleCapsLockIndicatorForAccountPasswordField();
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(e -> {
                    if (20 == e.getKeyCode()) {
                        this.self.toggleCapsLockIndicatorForAccountPasswordField();
                    }
                    return false;
                });
                this.accountPasswordTextfield.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        ClientGUI.this.self.toggleCapsLockIndicatorForAccountPasswordField();
                    }
                });
            }
            this.accountForgotPasswordLabel = GUIHelper.getLabel("[my_account_login_forgot_password]", 1, 12, Colors.LINK_COLOR);
            this.accountForgotPasswordLabel.setBounds(9, 155, 373, 16);
            this.accountForgotPasswordLabel.setVerticalAlignment(1);
            this.accountForgotPasswordLabel.setCursor(new Cursor(12));
            this.accountForgotPasswordLabel.addMouseListener(new LinkHover());
            this.accountForgotPasswordLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    Function.openLink(ClientGUI.this.self.lang.getTex("url_forgot_password"));
                }
            });
            this.accountLoginButton = GUIHelper.getGradientButton("[my_account_login]");
            this.accountLoginButton.setBounds(90, 193, 200, 32);
            this.accountLoginButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    ClientGUI.this.self.user.login();
                }
            });
            ResourceHelper.setComponentIcon(this.accountLoginButton, "sign-in.png", 17, 17);
            this.accountMiddleSeparator.setDoubleBuffered(false);
            this.accountMiddleSeparator.setBounds(388, 11, 1, 250);
            this.accountMiddleSeparator.setBackground(Colors.SEPERATOR_COLOR);
            this.accountMiddleSeparator.setForeground(Colors.SEPERATOR_COLOR);
            this.accountMiddleSeparator.setLayout(null);
            this.accountMiddleSeparator.setOrientation(1);
            this.accountRegisterTextLabel = GUIHelper.getLabel("[my_account_register_text]", Colors.TEXT_COLOR_REGULAR);
            this.accountRegisterTextLabel.setBounds(396, 5, 340, 200);
            this.accountRegisterTextLabel.setVerticalAlignment(1);
            this.accountRegisterButton = GUIHelper.getGradientButton("[my_account_register_now]");
            this.accountRegisterButton.setBounds(460, 193, 200, 32);
            this.accountRegisterButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    Function.openLink(ClientGUI.this.self.lang.getTex("url_register"));
                }
            });
            ResourceHelper.setComponentIcon(this.accountRegisterButton, "star.png", 17, 17);
            this.accountUserTitleLabel = GUIHelper.getLabel("[my_account_welcome]", 1, 14, Colors.TEXT_COLOR_REGULAR);
            this.accountUserTitleLabel.setBounds(10, 5, 726, 22);
            this.accountUserTitleLabel.setVerticalAlignment(1);
            this.accountUserTextLabel = GUIHelper.getLabel("[my_account_logged_text]", Colors.TEXT_COLOR_REGULAR);
            this.accountUserTextLabel.setBounds(10, 34, 726, 54);
            this.accountUserTextLabel.setVerticalAlignment(1);
            this.accountUserMyAccountTitleLabel = GUIHelper.getTitleLabel("[my_account_title]", 10, 88, 726, 22);
            this.accountUserMyAccountTitleLabel.setVerticalAlignment(1);
            this.accountUserMyAccountEditProfileLabel = GUIHelper.getLabel("[my_account_edit_profile]", Colors.LINK_COLOR);
            this.accountUserMyAccountEditProfileLabel.setBounds(10, 118, 726, 22);
            this.accountUserMyAccountEditProfileLabel.setVerticalAlignment(0);
            this.accountUserMyAccountEditProfileLabel.setCursor(new Cursor(12));
            this.accountUserMyAccountEditProfileLabel.addMouseListener(new LinkHover());
            this.accountUserMyAccountEditProfileLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    Function.openLink(ClientGUI.this.self.lang.getTex("url_edit_profile"));
                }
            });
            ResourceHelper.setComponentIcon(this.accountUserMyAccountEditProfileLabel, "user.png", 17, 17);
            this.accountUserMyAccountChangePasswordLabel = GUIHelper.getLabel("[my_account_change_password]", Colors.LINK_COLOR);
            this.accountUserMyAccountChangePasswordLabel.setBounds(10, 142, 726, 22);
            this.accountUserMyAccountChangePasswordLabel.setVerticalAlignment(0);
            this.accountUserMyAccountChangePasswordLabel.setCursor(new Cursor(12));
            this.accountUserMyAccountChangePasswordLabel.addMouseListener(new LinkHover());
            this.accountUserMyAccountChangePasswordLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    Function.openLink(ClientGUI.this.self.lang.getTex("url_change_password"));
                }
            });
            ResourceHelper.setComponentIcon(this.accountUserMyAccountChangePasswordLabel, "key.png", 17, 17);
            this.accountUserMyAccountLogoutButton = GUIHelper.getGradientButton("[my_account_logout]");
            this.accountUserMyAccountLogoutButton.setBounds(10, 186, 200, 32);
            this.accountUserMyAccountLogoutButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    ClientGUI.this.self.user.logout();
                }
            });
            ResourceHelper.setComponentIcon(this.accountUserMyAccountLogoutButton, "power-off.png", 17, 17);
            this.accountPanel.add(this.accountTitleLabel);
            this.accountGuestPanel.add(this.accountLoginTextLabel);
            this.accountGuestPanel.add(this.accountUsernameLabel);
            this.accountGuestPanel.add(this.accountUsernameTextfield);
            this.accountGuestPanel.add(this.accountPasswordLabel);
            this.accountGuestPanel.add(this.accountPasswordTextfield);
            this.accountPasswordTextfield.add(this.accountPasswordFieldCapsLockIndicator);
            this.accountGuestPanel.add(this.accountForgotPasswordLabel);
            this.accountGuestPanel.add(this.accountLoginButton);
            this.accountGuestPanel.add(this.accountMiddleSeparator);
            this.accountGuestPanel.add(this.accountRegisterTextLabel);
            this.accountGuestPanel.add(this.accountRegisterButton);
            this.accountUserPanel.add(this.accountUserTitleLabel);
            this.accountUserPanel.add(this.accountUserTextLabel);
            this.accountUserPanel.add(this.accountUserMyAccountTitleLabel);
            this.accountUserPanel.add(this.accountUserMyAccountEditProfileLabel);
            this.accountUserPanel.add(this.accountUserMyAccountChangePasswordLabel);
            this.accountUserPanel.add(this.accountUserMyAccountLogoutButton);
            this.accountPanel.add(this.accountGuestPanel);
            this.accountPanel.add(this.accountUserPanel);
        }
        catch (Exception e2) {
            ExceptionHandler.handle(e2);
        }
    }

    protected void initSettingsComponents() {
        try {
            this.settingsCompressionLevelSlider = new JSlider();
            this.settingsTitleLabel = GUIHelper.getTitleLabel("[menu_settings]", 7, 7, 728, 28);
            this.settingsTextLabel = GUIHelper.getLabel("[settings_description]", Colors.TEXT_COLOR_REGULAR);
            this.settingsTextLabel.setBounds(7, 39, 728, 40);
            this.settingsTextLabel.setVerticalAlignment(1);
            this.settingsESOTitleLabel = GUIHelper.getTitleLabel("[settings_eso_paths]", 7, 76, 728, 28);
            this.settingsESODataPathLabel = GUIHelper.getLabel("[settings_data_dir]", 0, 13);
            this.settingsESODataPathLabel.setBounds(12, 108, 728, 18);
            this.settingsESODataPathTextfield = GUIHelper.getTextField();
            this.settingsESODataPathTextfield.setBounds(12, 130, 540, 29);
            this.settingsESODataPathButton = GUIHelper.getGradientButton("[global_browse]");
            this.settingsESODataPathButton.setBounds(556, 130, 180, 29);
            this.settingsESODataPathButton.setHorizontalAlignment(2);
            this.settingsESODataPathButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    String newPath = Function.openFileChooser(ClientGUI.this.self, 1, ClientGUI.this.self.lang.getTex("global_choose_directory"), ClientGUI.this.self.settings.getValue("ESODataDir"));
                    if (newPath != null) {
                        ClientGUI.this.self.setDataPath(newPath, true);
                    }
                }
            });
            ResourceHelper.setComponentIcon(this.settingsESODataPathButton, "folder-open.png", 17, 17);
            this.settingsESODataPathDescLabel = GUIHelper.getLabel("[settings_data_dir_default]", 0, 12, Colors.INACTIVE_TEXT_COLOR);
            this.settingsESODataPathDescLabel.setBounds(15, 158, 728, 18);
            this.settingsDetectPathsButton = GUIHelper.getGradientButton("[settings_detect_paths]");
            this.settingsDetectPathsButton.setBounds(15, 200, 260, 29);
            this.settingsDetectPathsButton.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Colors.BORDER_COLOR), new EmptyBorder(0, 6, 0, 0)));
            this.settingsDetectPathsButton.setCursor(new Cursor(12));
            this.settingsDetectPathsButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    ClientGUI.this.self.detectDataPath(true);
                }
            });
            ResourceHelper.setComponentIcon(this.settingsDetectPathsButton, "folder-open.png", 17, 17);
            int settingsCheckboxYStep = 26;
            int settingsCheckboxY = 286;
            this.settingsClientTitleLabel = GUIHelper.getTitleLabel("[settings_client]", 7, 254, 728, 28);
            if (Function.getShortOSName().equals("windows") || Function.getShortOSName().equals("mac")) {
                this.settingsAutostartCheckBox = GUIHelper.getCheckBox("[settings_autostart]");
                this.settingsAutostartCheckBox.setBounds(7, settingsCheckboxY, 728, 28);
                this.settingsAutostartCheckBox.addItemListener(e -> {
                    if (e.getStateChange() == 1) {
                        if (Function.getShortOSName().equals("mac")) {
                            Autostart.enableAutostart(true);
                        } else {
                            Autostart.enableAutostart(this.settingsMinimizeTrayCheckBox.isSelected());
                        }
                        this.self.settings.setValue("Autostart", "1");
                    } else {
                        Autostart.disableAutostart();
                        this.self.settings.setValue("Autostart", "0");
                    }
                });
                settingsCheckboxY += settingsCheckboxYStep;
            }
            if (!Function.getShortOSName().equals("mac")) {
                this.settingsMinimizeTrayCheckBox = GUIHelper.getCheckBox("[settings_minimize_system_tray]");
                this.settingsMinimizeTrayCheckBox.setBounds(7, settingsCheckboxY, 728, 28);
                this.settingsMinimizeTrayCheckBox.addItemListener(e -> {
                    try {
                        if (e.getStateChange() == 1) {
                            this.self.settings.setValue("MinimizeToTray", "1");
                            if (SystemTray.isSupported()) {
                                this.self._tray.remove(this.self._trayIcon);
                                this.self._tray.add(this.self._trayIcon);
                            }
                        } else {
                            this.self.settings.setValue("MinimizeToTray", "0");
                            if (SystemTray.isSupported()) {
                                this.self._tray.remove(this.self._trayIcon);
                            }
                        }
                    }
                    catch (Exception err) {
                        ExceptionHandler.handle(err);
                    }
                });
                settingsCheckboxY += settingsCheckboxYStep;
            }
            this.settingsShowNotificationsCheckBox = GUIHelper.getCheckBox("[settings_show_upload_notifications]");
            this.settingsShowNotificationsCheckBox.setBounds(7, settingsCheckboxY, 728, 28);
            this.settingsShowNotificationsCheckBox.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.self.settings.setValue("ShowNotifications", "1");
                } else {
                    this.self.settings.setValue("ShowNotifications", "0");
                }
            });
            this.settingsCompressionLevelTitle = GUIHelper.getTitleLabel("[compression_settings]", 7, 382, 728, 28);
            UIDefaults defaults = UIManager.getDefaults();
            defaults.put("Slider.background", Colors.INACTIVE_TEXT_COLOR);
            defaults.put("Slider.focus", Colors.PANEL_COLOR);
            defaults.put("Slider.shadow", Colors.INPUT_BACKGROUND_COLOR);
            defaults.put("Slider.highlight", Colors.BORDER_INPUT_COLOR);
            defaults.put("Slider.tickColor", Colors.NAVIGATION_COLOR);
            this.settingsCompressionLevelSlider.setDoubleBuffered(false);
            this.settingsCompressionLevelSlider.setFont(new Font("Roboto", 0, 12));
            this.settingsCompressionLevelSlider.setForeground(Colors.TEXT_COLOR_REGULAR);
            this.settingsCompressionLevelSlider.setBounds(7, 422, 728, 40);
            this.settingsCompressionLevelSlider.setOpaque(false);
            this.settingsCompressionLevelSlider.setMinimum(1);
            this.settingsCompressionLevelSlider.setMaximum(9);
            this.settingsCompressionLevelSlider.setMinorTickSpacing(1);
            this.settingsCompressionLevelSlider.setMajorTickSpacing(4);
            this.settingsCompressionLevelSlider.setPaintTicks(true);
            this.settingsCompressionLevelSlider.setPaintLabels(true);
            this.settingsCompressionLevelSlider.setPaintTrack(true);
            this.settingsCompressionLevelSlider.setValue(Integer.parseInt(this.settings.getValue("CompressionLevel")));
            this.settingsCompressionLevelSlider.setUI(new BasicSliderUI(this.settingsCompressionLevelSlider));
            this.settingsCompressionLevelSlider.addChangeListener(e -> {
                JSlider slider = (JSlider)e.getSource();
                this.self.settings.setValue("CompressionLevel", Integer.toString(slider.getValue()));
                this.self.settingsCompressionLevelValueLabel.setText(this.self.getCompressionLevelText(slider.getValue()));
            });
            this.settingsCompressionLevelValueLabel = GUIHelper.getLabel("---", Colors.TEXT_COLOR_REGULAR);
            this.settingsCompressionLevelValueLabel.setBounds(7, 470, 728, 28);
            this.settingsCompressionLevelValueLabel.setOpaque(false);
            this.settingsPanel.add(this.settingsTitleLabel);
            this.settingsPanel.add(this.settingsTextLabel);
            this.settingsPanel.add(this.settingsESOTitleLabel);
            this.settingsPanel.add(this.settingsESODataPathLabel);
            this.settingsPanel.add(this.settingsESODataPathTextfield);
            this.settingsPanel.add(this.settingsESODataPathButton);
            this.settingsPanel.add(this.settingsESODataPathDescLabel);
            this.settingsPanel.add(this.settingsDetectPathsButton);
            this.settingsPanel.add(this.settingsClientTitleLabel);
            if (Function.getShortOSName().equals("windows") || Function.getShortOSName().equals("mac")) {
                this.settingsPanel.add(this.settingsAutostartCheckBox);
            }
            if (!Function.getShortOSName().equals("mac")) {
                this.settingsPanel.add(this.settingsMinimizeTrayCheckBox);
            }
            this.settingsPanel.add(this.settingsShowNotificationsCheckBox);
            this.settingsPanel.add(this.settingsCompressionLevelTitle);
            this.settingsPanel.add(this.settingsCompressionLevelSlider);
            this.settingsPanel.add(this.settingsCompressionLevelValueLabel);
        }
        catch (Exception e2) {
            ExceptionHandler.handle(e2);
        }
    }

    protected void initInformationComponents() {
        try {
            this.informationTitleLabel = GUIHelper.getTitleLabel("[menu_information]", 7, 7, 728, 28);
            this.informationTextLabel = GUIHelper.getLabel("[information_description]", Colors.TEXT_COLOR_REGULAR);
            this.informationTextLabel.setBounds(7, 39, 728, 40);
            this.informationTextLabel.setVerticalAlignment(1);
            this.informationTransferTitleLabel = GUIHelper.getTitleLabel("[information_transferred_data]", 7, 66, 728, 28);
            this.informationTransferredBytesLabel = GUIHelper.getLabel("[settings_total_transferred]", 0, 13, Colors.TEXT_COLOR_REGULAR);
            this.informationTransferredBytesLabel.setBounds(12, 96, 200, 28);
            this.informationTransferredBytesValueLabel = GUIHelper.getLabel("0 B", 0, 13, Colors.INACTIVE_TEXT_COLOR);
            this.informationTransferredBytesValueLabel.setBounds(210, 96, 400, 28);
            this.informationTransferredTotalLabel = GUIHelper.getLabel("[settings_total_transfers]", 0, 13, Colors.TEXT_COLOR_REGULAR);
            this.informationTransferredTotalLabel.setBounds(12, 120, 200, 28);
            this.informationTransferredTotalValueLabel = GUIHelper.getLabel("0", 0, 13, Colors.INACTIVE_TEXT_COLOR);
            this.informationTransferredTotalValueLabel.setBounds(210, 120, 400, 28);
            this.informationClientTitleLabel = GUIHelper.getTitleLabel("[settings_client_information]", 7, 156, 728, 28);
            this.informationClientVersionLabel = GUIHelper.getLabel("[global_version]", 0, 13, Colors.TEXT_COLOR_REGULAR);
            this.informationClientVersionLabel.setBounds(12, 181, 200, 28);
            this.informationClientVersionValueLabel = GUIHelper.getLabel("1.0.9 (" + this.lang.getTex("build") + " 10144)", 0, 13, Colors.INACTIVE_TEXT_COLOR);
            this.informationClientVersionValueLabel.setBounds(210, 181, 400, 28);
            this.informationClientChangelogTitleLabel = GUIHelper.getTitleLabel("[information_client_changelog_title]", 7, 214, 728, 28);
            this.informationClientChangelogRefreshLabel = GUIHelper.getTooltipLabel("", 0, 14, Colors.ACTIVE_TEXT_COLOR);
            this.informationClientChangelogRefreshLabel.setBounds(716, 216, 16, 16);
            this.informationClientChangelogRefreshLabel.setCursor(new Cursor(12));
            this.informationClientChangelogRefreshLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    Thread clientChangelogThread = new Thread(new FetchChangelog(FetchChangelog.Changelog.Client, ClientGUI.this.self, ClientGUI.this.self.informationClientChangelogPanel));
                    clientChangelogThread.setName("fetch_client_changelog");
                    clientChangelogThread.setDaemon(true);
                    clientChangelogThread.start();
                }
            });
            ResourceHelper.setComponentIcon(this.informationClientChangelogRefreshLabel, "refresh.png", 16, 16);
            this.informationClientChangelogPanel = GUIHelper.getScrollPanel(Colors.BORDER_INPUT_COLOR, 0, 0, 728, 130);
            this.informationClientChangelogPanel.setLayout(new BoxLayout(this.informationClientChangelogPanel, 1));
            this.informationClientChangelogScrollPane = new JScrollPane(this.informationClientChangelogPanel);
            this.informationClientChangelogScrollPane.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Colors.BORDER_COLOR));
            this.informationClientChangelogScrollPane.setBounds(7, 248, 728, 130);
            this.informationClientChangelogScrollPane.setHorizontalScrollBarPolicy(31);
            this.informationClientChangelogScrollPane.getVerticalScrollBar().setUnitIncrement(8);
            this.informationClientChangelogScrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(16, 0));
            this.informationClientChangelogScrollPane.getVerticalScrollBar().setUI(new ChangelogScrollBar());
            this.informationActionTitleLabel = GUIHelper.getTitleLabel("[settings_actions]", 7, 383, 728, 28);
            this.informationActionSearchForUpdatesButton = GUIHelper.getGradientButton("[menu_update_check]");
            this.informationActionSearchForUpdatesButton.setBounds(9, 420, 355, 29);
            this.informationActionSearchForUpdatesButton.setHorizontalAlignment(2);
            ResourceHelper.setComponentIcon(this.informationActionSearchForUpdatesButton, "flask.png", 17, 17);
            this.informationActionSearchForUpdatesButton.addMouseListener(new MouseAdapter(this){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    Thread updateCheckerThread = new Thread(new UpdateCheck(true));
                    updateCheckerThread.setName("update_check_thread");
                    updateCheckerThread.setDaemon(true);
                    updateCheckerThread.start();
                }
            });
            this.informationActionCheckComponentsButton = GUIHelper.getGradientButton("[diagnostic]");
            this.informationActionCheckComponentsButton.setBounds(375, 420, 355, 29);
            this.informationActionCheckComponentsButton.setHorizontalAlignment(2);
            this.informationActionCheckComponentsButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    try {
                        ClientGUI.this.self.checkComponentsPanel.setVisible(true);
                        ClientGUI.this.self.informationPanel.setVisible(false);
                        ClientGUI.this.self.mainLayeredPanel.moveToFront(ClientGUI.this.self.checkComponentsPanel);
                        ClientGUI.this.self.loadCheckComponentsData();
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle(e);
                    }
                }
            });
            ResourceHelper.setComponentIcon(this.informationActionCheckComponentsButton, "random.png", 16, 16);
            this.informationActionOpenLogFolderButton = GUIHelper.getGradientButton("[open_log_folder]");
            this.informationActionOpenLogFolderButton.setBounds(9, 459, 355, 29);
            this.informationActionOpenLogFolderButton.setHorizontalAlignment(2);
            this.informationActionOpenLogFolderButton.addMouseListener(new MouseAdapter(this){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    try {
                        String logFolderPath = Function.getLogFolderForOS();
                        File dir = new File(logFolderPath);
                        dir.mkdirs();
                        Function.openPath(logFolderPath);
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle(e);
                    }
                }
            });
            ResourceHelper.setComponentIcon(this.informationActionOpenLogFolderButton, "folder-open.png", 17, 17);
            this.informationCreditsTitleLabel = GUIHelper.getTitleLabel("[about_the_app]", 7, 500, 728, 28);
            this.informationCreditsTextLabel = GUIHelper.getLabel("[about_the_app_text]", 0, 13, Colors.TEXT_COLOR_REGULAR);
            this.informationCreditsTextLabel.setBounds(7, 533, 758, 48);
            this.informationCreditsTextLabel.setVerticalAlignment(1);
            ResourceHelper.setComponentIcon(this.informationCreditsTextLabel, "info-circle.png", 17, 17);
            this.informationPanel.add(this.informationTitleLabel);
            this.informationPanel.add(this.informationTextLabel);
            this.informationPanel.add(this.informationTransferTitleLabel);
            this.informationPanel.add(this.informationTransferredBytesLabel);
            this.informationPanel.add(this.informationTransferredBytesValueLabel);
            this.informationPanel.add(this.informationTransferredTotalLabel);
            this.informationPanel.add(this.informationTransferredTotalValueLabel);
            this.informationPanel.add(this.informationClientTitleLabel);
            this.informationPanel.add(this.informationClientVersionLabel);
            this.informationPanel.add(this.informationClientVersionValueLabel);
            this.informationPanel.add(this.informationClientChangelogRefreshLabel);
            this.informationPanel.add(this.informationClientChangelogTitleLabel);
            this.informationPanel.add(this.informationClientChangelogScrollPane);
            this.informationPanel.add(this.informationActionTitleLabel);
            this.informationPanel.add(this.informationActionSearchForUpdatesButton);
            this.informationPanel.add(this.informationActionOpenLogFolderButton);
            this.informationPanel.add(this.informationActionCheckComponentsButton);
            this.informationPanel.add(this.informationCreditsTitleLabel);
            this.informationPanel.add(this.informationCreditsTextLabel);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void initCheckComponents() {
        try {
            this.checkComponentsTitleLabel = GUIHelper.getTitleLabel("[check_components_title]", 7, 7, 728, 28);
            this.checkComponentsTextLabel = GUIHelper.getLabel("[check_components_description]", Colors.TEXT_COLOR_REGULAR);
            this.checkComponentsTextLabel.setBounds(7, 39, 728, 40);
            this.checkComponentsTextLabel.setVerticalAlignment(1);
            this.checkComponentsItemsPanel = GUIHelper.getPanel(Colors.PANEL_COLOR, null, 7, 70, 733, 456);
            this.checkComponentsCloseButton = GUIHelper.getGradientButton("[ok]");
            this.checkComponentsCloseButton.setBounds(320, 532, 120, 32);
            this.checkComponentsCloseButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    ClientGUI.this.self.navController.setActiveElement(ClientGUI.this.self.navInformationLabel.getName());
                }
            });
            ResourceHelper.setComponentIcon(this.checkComponentsCloseButton, "chevron-left.png", 17, 17);
            this.checkComponentsPanel.add(this.checkComponentsCloseButton);
            this.checkComponentsPanel.add(this.checkComponentsTitleLabel);
            this.checkComponentsPanel.add(this.checkComponentsTextLabel);
            this.checkComponentsPanel.add(this.checkComponentsItemsPanel);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void createSysTray() {
        try {
            if (SystemTray.isSupported()) {
                PopupMenu popup = new PopupMenu();
                popup.setFont(new Font("Roboto", 0, 14));
                this.showMenuItem = new MenuItem("[menu_show]");
                this.hideMenuItem = new MenuItem("[menu_hide]");
                this.openESODBMenuItem = new MenuItem("[menu_open_website]");
                this.updateMenuItem = new MenuItem("[menu_update_check]");
                this.settingsMenuItem = new MenuItem("[menu_settings]");
                this.exitItem = new MenuItem("[menu_close_app]");
                this.showMenuItem.setFont(new Font("Roboto", 0, 14));
                this.hideMenuItem.setFont(new Font("Roboto", 0, 14));
                this.openESODBMenuItem.setFont(new Font("Roboto", 0, 14));
                this.updateMenuItem.setFont(new Font("Roboto", 0, 14));
                this.settingsMenuItem.setFont(new Font("Roboto", 0, 14));
                this.exitItem.setFont(new Font("Roboto", 0, 14));
                this.hideMenuItem.setEnabled(false);
                this.showMenuItem.addActionListener(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ClientGUI.this.self.showApp();
                    }
                });
                this.hideMenuItem.addActionListener(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ClientGUI.this.self.hideApp();
                    }
                });
                this.openESODBMenuItem.addActionListener(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Function.openLink("https://www.eso-hub.com");
                    }
                });
                this.updateMenuItem.addActionListener(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Thread updateCheckerThread = new Thread(new UpdateCheck(true));
                        updateCheckerThread.setName("update_check_thread");
                        updateCheckerThread.setDaemon(true);
                        updateCheckerThread.start();
                        ClientGUI.this.self.showApp();
                    }
                });
                this.settingsMenuItem.addActionListener(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ClientGUI.this.self.navController.setActiveElement(ClientGUI.this.self.navSettingsLabel.getName());
                        ClientGUI.this.self.showApp();
                    }
                });
                this.exitItem.addActionListener(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.exit(0);
                    }
                });
                popup.add(this.showMenuItem);
                popup.add(this.hideMenuItem);
                popup.addSeparator();
                popup.add(this.openESODBMenuItem);
                popup.add(this.updateMenuItem);
                popup.add(this.settingsMenuItem);
                popup.addSeparator();
                popup.add(this.exitItem);
                Image trayImage = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(Function.getTrayIconPath()));
                if (trayImage != null) {
                    this._trayIcon = new TrayIcon(trayImage, "ESO-Hub Client", popup);
                }
                this._trayIcon.setImageAutoSize(true);
                this._tray = SystemTray.getSystemTray();
                if (this.settings.getValue("MinimizeToTray").equals("1")) {
                    this._tray.add(this._trayIcon);
                }
                this._trayIcon.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseReleased(MouseEvent evt) {
                        if (!Function.getShortOSName().equals("mac") && evt.getClickCount() == 2) {
                            if (ClientGUI.this.self.settingsMinimizeTrayCheckBox.isSelected()) {
                                if (ClientGUI.this.self.isVisible()) {
                                    ClientGUI.this.self.hideApp();
                                } else {
                                    ClientGUI.this.self.showApp();
                                }
                            } else if (ClientGUI.this.self.getExtendedState() == 0) {
                                ClientGUI.this.self.hideApp();
                            } else {
                                ClientGUI.this.self.showApp();
                            }
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public void bringToFront() {
        try {
            super.setVisible(true);
            int state = super.getExtendedState();
            super.setExtendedState(state &= 0xFFFFFFFE);
            super.setAlwaysOnTop(true);
            super.toFront();
            super.requestFocus();
            super.setAlwaysOnTop(false);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void showApp() {
        try {
            this.self.setExtendedState(0);
            this.self.setVisible(true);
            this.bringToFront();
            if (SystemTray.isSupported()) {
                this.self.showMenuItem.setEnabled(false);
                this.self.hideMenuItem.setEnabled(true);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void hideApp() {
        try {
            if (!Function.getShortOSName().equals("mac")) {
                if (this.settingsMinimizeTrayCheckBox.isSelected()) {
                    this.self.setVisible(false);
                } else {
                    this.self.setVisible(true);
                    this.self.setExtendedState(1);
                }
            } else {
                this.self.setVisible(false);
            }
            if (SystemTray.isSupported()) {
                this.self.showMenuItem.setEnabled(true);
                this.self.hideMenuItem.setEnabled(false);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected synchronized void setInvalidDataPathVisible(boolean status) {
        block4: {
            try {
                Component[] addons;
                if (status) {
                    this.addonsItemsPanel.removeAll();
                    this.dashboardInvalidDataPathPanel.setVisible(true);
                    this.dashboardManageAddonsPanel.setVisible(false);
                    this.addonInvalidPathPanel = GUIHelper.getPanel(Colors.NOTIFICATION_PANEL_COLOR, null, 0, 0, 728, 78);
                    this.addonInvalidPathPanel.setName("addons_invalid_data_path_panel");
                    this.addonInvalidPathPanel.setVisible(true);
                    this.addonInvalidPathPanel.setCursor(new Cursor(12));
                    this.addonInvalidPathPanel.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseReleased(MouseEvent evt) {
                            ClientGUI.this.self.navController.setActiveElement(ClientGUI.this.self.navSettingsLabel.getName());
                        }
                    });
                    this.addonInvalidDataPathLabel = GUIHelper.getLabel(this.lang.getTex("dashboard_invalid_data_path"), 0, 13, Colors.BLACK_TEXT_COLOR);
                    this.addonInvalidDataPathLabel.setBounds(6, 6, 600, 70);
                    this.addonInvalidDataPathLabel.setVerticalAlignment(0);
                    this.addonInvalidDataPathLabel.setHorizontalAlignment(0);
                    this.addonInvalidDataPathLabel.setIconTextGap(10);
                    ResourceHelper.setComponentIcon(this.addonInvalidDataPathLabel, "exclamation-triangle.png", 38, 38);
                    this.addonInvalidPathPanel.add(this.addonInvalidDataPathLabel);
                    this.addonsItemsPanel.add(this.addonInvalidPathPanel);
                    break block4;
                }
                this.dashboardInvalidDataPathPanel.setVisible(false);
                this.dashboardManageAddonsPanel.setVisible(true);
                if (this.addonsItemsPanel == null) break block4;
                for (Component comp : addons = this.addonsItemsPanel.getComponents()) {
                    if (comp.getName() == null || !comp.getName().equals("addons_invalid_data_path_panel")) continue;
                    this.addonsItemsPanel.remove(this.addonInvalidPathPanel);
                    break;
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    protected synchronized void toggleCapsLockIndicatorForAccountPasswordField() {
        try {
            boolean capsLockActive = Toolkit.getDefaultToolkit().getLockingKeyState(20);
            this.accountPasswordFieldCapsLockIndicator.setVisible(capsLockActive);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void loadData() {
        try {
            String transferredBytes = this.settings.getValue("TransferredBytes");
            String transferredFiles = this.settings.getValue("TransferredFiles");
            this.setTransferredFiles(Function.numberFormat(Long.parseLong(transferredFiles), 0));
            this.setTransferredBytes(Function.bytesToHuman(Long.parseLong(transferredBytes)));
            this.setDataPath(this.settings.getValue("ESODataDir"), false);
            if (this.settings.getValue("Autostart").equals("1")) {
                this.settingsAutostartCheckBox.setSelected(true);
            }
            if (!Function.getShortOSName().equals("mac") && this.settings.getValue("MinimizeToTray").equals("1")) {
                this.settingsMinimizeTrayCheckBox.setSelected(true);
            }
            if (this.settings.getValue("ShowNotifications").equals("1")) {
                this.settingsShowNotificationsCheckBox.setSelected(true);
            }
            int compressionLevel = Integer.parseInt(this.settings.getValue("CompressionLevel"));
            this.settingsCompressionLevelValueLabel.setText(this.getCompressionLevelText(compressionLevel));
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected String getCompressionLevelText(int level) {
        return this.lang.getTex("settings_compression_level_" + level);
    }

    protected void loadCheckComponentsData() {
        try {
            Thread checkComponentsThread = new Thread(new CheckComponents());
            checkComponentsThread.setName("check_Components_thread");
            checkComponentsThread.setDaemon(true);
            checkComponentsThread.start();
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }
}

