/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client.components;

import com.hub.eso.client.utils.ExceptionHandler;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class ESODBProgressBar
extends BasicProgressBarUI {
    protected final Color backgroundColor;
    protected final Color barColor;

    public ESODBProgressBar(Color background, Color bar) {
        this.backgroundColor = background;
        this.barColor = bar;
    }

    @Override
    protected Dimension getPreferredInnerVertical() {
        return new Dimension(20, 146);
    }

    @Override
    protected Dimension getPreferredInnerHorizontal() {
        return new Dimension(146, 20);
    }

    @Override
    protected void paintDeterminate(Graphics g, JComponent c) {
        if (this.progressBar.getOrientation() != 0) {
            super.paintDeterminate(g, c);
            return;
        }
        try {
            Graphics2D g2d = (Graphics2D)g.create();
            int iStrokeWidth = 1;
            int width = this.progressBar.getWidth();
            int height = this.progressBar.getHeight();
            int iInnerHeight = height - iStrokeWidth * 4;
            int iInnerWidth = width - iStrokeWidth * 4;
            int x = iStrokeWidth * 2;
            int y = iStrokeWidth * 2;
            int strokeRadius = 6;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setStroke(new BasicStroke(iStrokeWidth, 0, 0));
            g2d.setColor(this.backgroundColor);
            g2d.setBackground(this.backgroundColor);
            RoundRectangle2D.Double outline = new RoundRectangle2D.Double((double)iStrokeWidth / 2.0, (double)iStrokeWidth / 2.0, width - iStrokeWidth, height - iStrokeWidth, strokeRadius, strokeRadius);
            g2d.fill(outline);
            double dProgress = this.progressBar.getPercentComplete();
            if (dProgress < 0.0) {
                dProgress = 0.0;
            } else if (dProgress > 1.0) {
                dProgress = 1.0;
            }
            iInnerWidth = (int)Math.round((double)iInnerWidth * dProgress);
            Point2D.Double start = new Point2D.Double(x, y);
            Point2D.Double end = new Point2D.Double(x, y + iInnerHeight);
            float[] dist = new float[]{0.0f, 0.5f, 1.0f};
            Color[] colors = new Color[]{this.barColor, this.barColor, this.barColor};
            LinearGradientPaint p = new LinearGradientPaint(start, end, dist, colors);
            g2d.setPaint(p);
            RoundRectangle2D.Double fill = new RoundRectangle2D.Double(iStrokeWidth * 2, iStrokeWidth * 2, iInnerWidth, iInnerHeight, strokeRadius, strokeRadius);
            g2d.fill(fill);
            g2d.dispose();
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    @Override
    protected void paintIndeterminate(Graphics g, JComponent c) {
        super.paintIndeterminate(g, c);
    }
}

