/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client.components;

import com.hub.eso.client.ClientGUI;
import com.hub.eso.client.components.ESODBProgressBar;
import com.hub.eso.client.components.JGradientButton;
import com.hub.eso.client.components.JTooltipCheckBox;
import com.hub.eso.client.gui.GUIHelper;
import com.hub.eso.client.gui.ResourceHelper;
import com.hub.eso.client.language.LanguageHandler;
import com.hub.eso.client.storage.AddOnTransferMeta;
import com.hub.eso.client.threads.AddOnPanelBuilder;
import com.hub.eso.client.threads.InstallAddOn;
import com.hub.eso.client.threads.TransferWorker;
import com.hub.eso.client.utils.ExceptionHandler;
import com.hub.eso.client.utils.Function;
import com.hub.eso.client.utils.Settings;
import com.hub.eso.client.vars.Colors;
import com.hub.eso.client.vars.Const;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class JAddOnPanel
extends JPanel {
    public static final int STATUS_VERSION = 1;
    public static final int STATUS_COMPRESSION = 2;
    public static final int STATUS_TRANSFER = 3;
    public static final int STATUS_SERVER_ACTION = 4;
    public static final int STATUS_DOWNLOAD = 5;
    public static final int STATUS_DECOMPRESSION = 6;
    public static final int STATUS_ERROR = 7;
    protected final JAddOnPanel self;
    protected final LanguageHandler lang;
    protected final Settings settings;
    protected final String addOnFolderName;
    protected String file;
    protected String fileChecksum;
    protected String savedVariablesFileName;
    protected String addOnName;
    protected String description;
    protected int serverVersionInt;
    protected String serverVersionStr;
    protected int localVersionInt;
    protected String localVersionStr;
    protected int status;
    protected boolean disableable;
    protected boolean enabled;
    protected final JLabel iconLabel;
    protected final JLabel nameLabel;
    protected final JLabel descriptionLabel;
    protected final JLabel separatorLabel;
    protected final JLabel lastTransferLabel;
    protected final JLabel versionLabel;
    protected final JProgressBar progressBar;
    protected final JGradientButton downloadButton;
    protected final JGradientButton uploadButton;
    protected final JTooltipCheckBox addOnEnabledCheckBox;
    protected final JLabel addOnEnabledStatusText;

    public JAddOnPanel(String addonFolderName) {
        ClientGUI mainGUI = ClientGUI.getInstance();
        this.self = this;
        this.lang = mainGUI.getLanguageHandler();
        this.settings = mainGUI.getSettings();
        this.addOnFolderName = addonFolderName;
        this.file = "";
        this.fileChecksum = "";
        this.savedVariablesFileName = "";
        this.addOnName = "";
        this.description = "";
        this.serverVersionInt = 0;
        this.serverVersionStr = "";
        this.localVersionInt = 0;
        this.localVersionStr = "";
        this.status = 1;
        this.disableable = false;
        this.enabled = true;
        this.iconLabel = GUIHelper.getLabel();
        this.nameLabel = GUIHelper.getLabel("", 1, 15, Colors.NOTIFICATION_PANEL_COLOR);
        this.descriptionLabel = GUIHelper.getLabel("", 0, 13);
        this.separatorLabel = GUIHelper.getLabel();
        this.lastTransferLabel = GUIHelper.getLabel("", 0, 11, Colors.TEXT_COLOR_REGULAR);
        this.versionLabel = GUIHelper.getLabel("", 0, 13);
        this.progressBar = new JProgressBar();
        this.downloadButton = GUIHelper.getGradientButton("");
        this.uploadButton = GUIHelper.getGradientButton("");
        this.addOnEnabledCheckBox = GUIHelper.getTooltipCheckBox("");
        this.addOnEnabledStatusText = GUIHelper.getLabel("", 0, 13, Colors.TEXT_COLOR_REGULAR);
        try {
            this.setName("JAddOnPanel_" + this.addOnFolderName);
            this.setDoubleBuffered(false);
            this.setBackground(Colors.ADDON_PANEL_COLOR);
            this.setLayout(null);
            this.setPreferredSize(new Dimension(712, 126));
            this.setMinimumSize(new Dimension(712, 126));
            this.setMaximumSize(new Dimension(712, 126));
            this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Colors.ADDON_PANEL_BORDER_COLOR));
            this.setAlignmentX(0.0f);
            this.iconLabel.setName("addonIconLabel_" + this.addOnFolderName);
            this.iconLabel.setBounds(12, 5, 48, 48);
            ResourceHelper.setComponentIcon(this.iconLabel, "archive.png", 42, 42);
            this.nameLabel.setName("addonNameLabel_" + this.addOnFolderName);
            this.nameLabel.setText("");
            this.nameLabel.setBounds(64, 7, 600, 25);
            this.descriptionLabel.setName("addonDescriptionLabel_" + this.addOnFolderName);
            this.descriptionLabel.setBounds(64, 26, 600, 25);
            this.separatorLabel.setName("separatorLabel_" + this.addOnFolderName);
            this.separatorLabel.setBounds(5, 58, 702, 1);
            this.separatorLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Colors.BORDER_BRIGHT_COLOR));
            this.downloadButton.setName("addonDownloadButton_" + this.addOnFolderName);
            this.downloadButton.setBounds(572, 88, 134, 32);
            ResourceHelper.setComponentIcon(this.downloadButton, "download.png", 17, 17);
            this.downloadButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    if (JAddOnPanel.this.self.downloadButton.isEnabled()) {
                        Thread addonWorkerThread = new Thread(new InstallAddOn(false, JAddOnPanel.this.self.addOnName, JAddOnPanel.this.self.addOnFolderName, JAddOnPanel.this.self.file, JAddOnPanel.this.self.fileChecksum));
                        addonWorkerThread.setName("install_addon_" + JAddOnPanel.this.self.addOnFolderName);
                        addonWorkerThread.setDaemon(true);
                        addonWorkerThread.start();
                    }
                }
            });
            this.uploadButton.setName("addonUploadButton_" + this.addOnFolderName);
            this.uploadButton.setBounds(450, 88, 116, 32);
            ResourceHelper.setComponentIcon(this.uploadButton, "upload.png", 17, 17);
            this.uploadButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    if (JAddOnPanel.this.self.uploadButton.isEnabled()) {
                        JAddOnPanel.this.self.startTransfer(true);
                    }
                }
            });
            this.lastTransferLabel.setName("addonLastTransferLabel_" + this.addOnFolderName);
            this.lastTransferLabel.setBounds(384, 64, 320, 20);
            this.lastTransferLabel.setHorizontalAlignment(4);
            ResourceHelper.setComponentIcon(this.lastTransferLabel, "refresh.png", 10, 10);
            this.versionLabel.setName("addonLocalVersionLabel_" + this.addOnFolderName);
            this.versionLabel.setBounds(12, 64, 350, 25);
            this.addOnEnabledCheckBox.setName("disableAddOnCheckBox_" + this.addOnFolderName);
            this.addOnEnabledCheckBox.setBounds(684, 2, 28, 28);
            this.addOnEnabledCheckBox.addItemListener(e -> {
                String enabled = e.getStateChange() == 1 ? "1" : "0";
                this.self.settings.setValue("AddOnEnabled" + this.self.getAddonFolderName(), enabled);
                this.self.setEnabledStatus();
                if (e.getStateChange() == 1) {
                    Thread addonWorkerThread = new Thread(new InstallAddOn(false, this.self.addOnName, this.self.addOnFolderName, this.self.file, this.self.fileChecksum));
                    addonWorkerThread.setName("install_addon_" + this.self.addOnFolderName);
                    addonWorkerThread.setDaemon(true);
                    addonWorkerThread.start();
                } else {
                    this.self.deleteAddOnFolder();
                }
            });
            this.addOnEnabledStatusText.setName("addOnEnabledStatusText_" + this.addOnFolderName);
            this.addOnEnabledStatusText.setText("");
            this.addOnEnabledStatusText.setHorizontalAlignment(4);
            this.addOnEnabledStatusText.setBounds(540, 3, 140, 25);
            this.progressBar.setName("addonProgressBar_" + this.addOnFolderName);
            this.progressBar.setDoubleBuffered(false);
            this.progressBar.setBounds(10, 98, 420, 12);
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(100);
            this.progressBar.setValue(0);
            this.progressBar.setOpaque(true);
            this.progressBar.setUI(new ESODBProgressBar(Colors.PROGRESSBAR_BACKGROUND, Colors.PROGRESSBAR_COLOR));
            this.progressBar.setVisible(false);
            this.progressBar.setBorder(null);
            this.progressBar.setBackground(this.getBackground());
            this.add(this.iconLabel);
            this.add(this.nameLabel);
            this.add(this.descriptionLabel);
            this.add(this.separatorLabel);
            this.add(this.uploadButton);
            this.add(this.downloadButton);
            this.add(this.lastTransferLabel);
            this.add(this.versionLabel);
            this.add(this.progressBar);
        }
        catch (Exception e2) {
            ExceptionHandler.handle(e2);
        }
    }

    public String getAddonFolderName() {
        return this.addOnFolderName;
    }

    public String getAddOnName() {
        return this.addOnName;
    }

    public String getFile() {
        return this.file;
    }

    public String getFileChecksum() {
        return this.fileChecksum;
    }

    public boolean getDisableable() {
        return this.disableable;
    }

    public int getServerVersionInt() {
        return this.serverVersionInt;
    }

    public int getLocalVersionInt() {
        return this.localVersionInt;
    }

    public String getLocalVersionStr() {
        return this.localVersionStr;
    }

    public boolean getAddOnEnabled() {
        return this.enabled;
    }

    public String getSavedVariablesFileName() {
        return this.savedVariablesFileName;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setFileChecksum(String checksum) {
        this.fileChecksum = checksum;
    }

    public void setSavedVariablesFileName(String fileName) {
        this.savedVariablesFileName = fileName;
    }

    public void setAddOnName(String name) {
        this.addOnName = name;
        this.nameLabel.setText(name);
    }

    public void setDescription(String desc) {
        this.description = desc;
        this.descriptionLabel.setText(this.description);
    }

    public void setServerVersionInt(int version) {
        this.serverVersionInt = version;
    }

    public void setServerVersionStr(String version) {
        this.serverVersionStr = version;
    }

    public void setLocalVersionInt(int version) {
        this.localVersionInt = version;
    }

    public void setLocalVersionStr(String version) {
        this.localVersionStr = version;
    }

    public void disableTransfer() {
        this.remove(this.uploadButton);
        this.remove(this.lastTransferLabel);
    }

    public void setStatus(int status) {
        this.status = status;
        this.setStatusTextFromStatus();
    }

    public void setStatusText(String text) {
        this.versionLabel.setText(text);
    }

    public void setStatusColor(Color color) {
        this.versionLabel.setForeground(color);
    }

    public void setDisableable(boolean status) {
        if (this.disableable != status) {
            if (status) {
                this.add(this.addOnEnabledStatusText);
                this.add(this.addOnEnabledCheckBox);
            } else {
                this.remove(this.addOnEnabledStatusText);
                this.remove(this.addOnEnabledCheckBox);
            }
        }
        this.disableable = status;
    }

    public void setStatusIcon(String assetPath) {
        try {
            ResourceHelper.setComponentIcon(this.versionLabel, assetPath, 17, 17);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public void setProgressBar(int percent, boolean show) {
        if (show) {
            this.progressBar.setVisible(true);
            this.progressBar.setValue(percent);
        } else {
            this.progressBar.setVisible(false);
            this.progressBar.setValue(0);
        }
    }

    public void setDownloadButtonEnabled(boolean status) {
        this.downloadButton.setEnabled(status);
    }

    public void setUploadButtonEnabled(boolean status) {
        this.uploadButton.setEnabled(status);
    }

    public void setStatusTextFromStatus() {
        switch (this.status) {
            case 1: {
                this.setStatusVersion();
                break;
            }
            case 2: {
                this.setStatusCompression();
                break;
            }
            case 3: {
                this.setStatusTransfer();
                break;
            }
            case 4: {
                this.setStatusServerAction();
                break;
            }
            case 5: {
                this.setStatusDownload();
                break;
            }
            case 6: {
                this.setStatusDecompression();
                break;
            }
            case 7: {
                this.setStatusError();
            }
        }
    }

    public void setTranslations() {
        this.uploadButton.setText(this.lang.getTex("upload"));
        this.downloadButton.setText(this.lang.getTex("download"));
        this.addOnEnabledCheckBox.setToolTipText(this.lang.getTex("addon_panel_enabled_status_tooltip"));
    }

    public void setLastTransfer() {
        try {
            Object lastSent = this.settings.getValue("LastSentAddOn" + this.getAddonFolderName());
            lastSent = ((String)lastSent).isEmpty() ? this.lang.getTex("data_no_transfer") : "<html><strong>" + this.lang.getTex("settings_last_transfer") + ":</strong> " + Function.getFormatedDate(Long.parseLong((String)lastSent)) + "</html>";
            this.lastTransferLabel.setText((String)lastSent);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public void setEnabledStatus() {
        try {
            Component[] comps;
            this.enabled = false;
            if (this.disableable) {
                String enabledSetting = this.settings.getValue("AddOnEnabled" + this.getAddonFolderName());
                if (enabledSetting.isEmpty()) {
                    this.settings.setValue("AddOnEnabled", "1");
                    enabledSetting = "1";
                }
                if (enabledSetting.equals("1")) {
                    this.enabled = true;
                }
            } else {
                this.enabled = true;
            }
            this.addOnEnabledCheckBox.setSelectedState(this.enabled);
            if (this.enabled) {
                this.addOnEnabledStatusText.setForeground(Colors.GREEN_STATUS_COLOR);
                this.addOnEnabledStatusText.setText(this.lang.getTex("addon_active"));
                this.setBackground(Colors.ADDON_PANEL_COLOR);
            } else {
                this.addOnEnabledStatusText.setForeground(Colors.INACTIVE_TEXT_COLOR);
                this.addOnEnabledStatusText.setText(this.lang.getTex("addon_inactive"));
                this.setBackground(Colors.ADDON_PANEL_COLOR.brighter());
            }
            for (Component comp : comps = this.getComponents()) {
                if (!(comp instanceof JGradientButton)) continue;
                comp.setEnabled(this.enabled);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public void deleteAddOnFolder() {
        try {
            String addOnFolderPath;
            String esoDataDir = AddOnPanelBuilder.getEsoDataDir();
            if (!esoDataDir.isEmpty() && Function.dirExists(addOnFolderPath = esoDataDir + File.separator + "AddOns" + File.separator + this.getAddonFolderName())) {
                FileUtils.deleteDirectory(new File(addOnFolderPath));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public void startTransfer(boolean userInteraction) {
        try {
            String esoDataDir = ClientGUI.getInstance().getSettings().getValue("ESODataDir");
            if (!esoDataDir.isEmpty() && Function.fileExists(esoDataDir)) {
                String megaserverSavedVariablesPath = esoDataDir + Const.ESO_SV_LIVE_DIR + File.separator + this.self.savedVariablesFileName;
                String endpoint = AddOnTransferMeta.getInstance().getEndpoint(this.self.savedVariablesFileName);
                if (new File(megaserverSavedVariablesPath).exists()) {
                    Thread transferThread = new Thread(new TransferWorker(new File(megaserverSavedVariablesPath), endpoint, this.self.addOnFolderName));
                    transferThread.setName("transfer_thread_" + this.self.file);
                    transferThread.setDaemon(true);
                    transferThread.start();
                } else if (userInteraction) {
                    ClientGUI.getInstance().showNotification(this.self.lang.getTex("addon_upload_no_sv_file_title"), this.self.lang.getTex("addon_upload_no_sv_file_text"));
                }
            } else if (userInteraction) {
                ClientGUI.getInstance().showNotification(this.self.lang.getTex("addon_upload_no_sv_file_title"), this.self.lang.getTex("addon_upload_no_sv_file_text"));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void setStatusCompression() {
        this.setDownloadButtonEnabled(false);
        this.setUploadButtonEnabled(false);
        this.setStatusIcon("sort.png");
        this.setStatusColor(Colors.NOTIFICATION_PANEL_COLOR);
        this.setStatusText(this.lang.getTex("upload_status_data_compression"));
    }

    protected void setStatusTransfer() {
        this.setStatusIcon("upload.png");
        this.setStatusColor(Colors.NOTIFICATION_PANEL_COLOR);
    }

    protected void setStatusServerAction() {
        this.setStatusIcon("flask.png");
        this.setStatusColor(Colors.NOTIFICATION_PANEL_COLOR);
        this.setStatusText(this.lang.getTex("upload_status_data_server"));
    }

    protected void setStatusDownload() {
        this.setDownloadButtonEnabled(false);
        this.setUploadButtonEnabled(false);
        this.setStatusIcon("download.png");
        this.setStatusColor(Colors.NOTIFICATION_PANEL_COLOR);
    }

    protected void setStatusDecompression() {
        this.setDownloadButtonEnabled(false);
        this.setUploadButtonEnabled(false);
    }

    protected void setStatusError() {
        this.setDownloadButtonEnabled(true);
        this.setUploadButtonEnabled(true);
        this.setStatusIcon("exclamation-triangle-white.png");
        this.setStatusColor(Colors.ERROR);
        this.setStatusText(this.lang.getTex("upload_server_error"));
    }

    protected void setStatusVersion() {
        try {
            String icon;
            Color color;
            String text;
            this.setDownloadButtonEnabled(true);
            this.setUploadButtonEnabled(true);
            this.setProgressBar(0, false);
            if (this.getLocalVersionInt() < 1) {
                text = StringUtils.replace(this.lang.getTex("addon_is_not_installed"), "%version%", this.serverVersionStr);
                color = Colors.LINK_COLOR;
                icon = "info-circle.png";
            } else if (this.getLocalVersionInt() < this.getServerVersionInt()) {
                text = StringUtils.replace(this.lang.getTex("addon_new_version_info"), "%local_version%", this.localVersionStr);
                text = StringUtils.replace(text, "%live_version%", this.serverVersionStr);
                color = Colors.ADDON_NOTICE_COLOR;
                icon = "download.png";
            } else {
                text = StringUtils.replace(this.lang.getTex("addon_is_installed"), "%version%", this.localVersionStr);
                color = Colors.GREEN_STATUS_COLOR;
                icon = "check.png";
            }
            this.setStatusText(text);
            this.setStatusColor(color);
            this.setStatusIcon(icon);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }
}

