/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client.language;

import com.hub.eso.client.language.LanguageDE;
import com.hub.eso.client.language.LanguageEN;
import com.hub.eso.client.utils.ExceptionHandler;
import java.util.HashMap;

public class LanguageHandler {
    protected HashMap<String, String> entries;
    protected Language lang;

    public LanguageHandler() {
        try {
            String systemLang = System.getProperty("user.language").toLowerCase();
            this.lang = systemLang.equals("de") ? Language.de : Language.en;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public String getTex(String key) {
        try {
            if (this.entries.containsKey(key)) {
                return this.entries.get(key);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        return "[" + key + "]";
    }

    public Language getLanguage() {
        return this.lang;
    }

    public void setLanguage(Language lang) {
        this.lang = lang;
        this.entries = lang == Language.de ? LanguageDE.getEntries() : LanguageEN.getEntries();
    }

    public static enum Language {
        de,
        en;

    }
}

