/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client.threads;

import com.hub.eso.client.ClientGUI;
import com.hub.eso.client.gui.GUIHelper;
import com.hub.eso.client.gui.ResourceHelper;
import com.hub.eso.client.language.LanguageHandler;
import com.hub.eso.client.threads.Threads;
import com.hub.eso.client.utils.ExceptionHandler;
import com.hub.eso.client.web.WebClass;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.json.JSONArray;
import org.json.JSONObject;

public class FetchChangelog
implements Runnable {
    protected final WebClass web;
    protected final LanguageHandler lang;
    protected final JPanel changelogPanel;
    protected final LinkedHashMap<Integer, JLabel> labels;
    protected final Changelog changelog;
    protected int labelCount;

    public FetchChangelog(Changelog changelog, ClientGUI mainGUI, JPanel changelogPanel) {
        this.web = mainGUI.getWebClass();
        this.lang = mainGUI.getLanguageHandler();
        this.changelogPanel = changelogPanel;
        this.labels = new LinkedHashMap();
        this.changelog = changelog;
        this.labelCount = 1;
    }

    @Override
    public void run() {
        try {
            if (!Threads.getInstance().addThreadToStack(Thread.currentThread().getName(), Thread.currentThread())) {
                Thread prevThread = Threads.getInstance().getThreadFromStack(Thread.currentThread().getName());
                prevThread.interrupt();
                while (prevThread.isAlive()) {
                    Thread.sleep(1000L);
                }
                Threads.getInstance().addThreadToStack(Thread.currentThread().getName(), Thread.currentThread());
            }
            if (this.changelog == Changelog.AddOn) {
                ClientGUI.getInstance().setDashboardChangelogRefreshLabelEnabled(false);
            } else {
                ClientGUI.getInstance().setInformationClientChangelogRefreshLabelEnabled(false);
            }
            this.changelogPanel.removeAll();
            this.createVersionLabel(this.lang.getTex("dashboard_changelog_loading"), true);
            JSONObject changelogResult = this.changelog == Changelog.Client ? this.web.getClientChangelog(this.lang.getLanguage()) : this.web.getAddOnChangelog(this.lang.getLanguage());
            if (changelogResult != null && changelogResult.has("changelog")) {
                JSONArray responseJson = changelogResult.getJSONArray("changelog");
                int changelogEntries = responseJson.length();
                for (int i = 0; i < changelogEntries; ++i) {
                    this.createVersionLabel(this.lang.getTex("version") + " " + responseJson.getJSONObject(i).getString("version"), false);
                    JSONArray lines = responseJson.getJSONObject(i).getJSONArray("lines");
                    int linesLength = lines.length();
                    for (int x = 0; x < linesLength; ++x) {
                        this.createTextLabel(lines.getString(x));
                    }
                }
                this.appendLabels();
                this.changelogPanel.remove(0);
            } else {
                this.changelogPanel.removeAll();
                this.createVersionLabel(this.lang.getTex("dashboard_changelog_error"), true);
            }
            this.changelogPanel.updateUI();
            if (this.changelog == Changelog.AddOn) {
                ClientGUI.getInstance().setDashboardChangelogRefreshLabelEnabled(true);
            } else {
                ClientGUI.getInstance().setInformationClientChangelogRefreshLabelEnabled(true);
            }
            Threads.getInstance().removeThreadFromStack(Thread.currentThread().getName());
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void createVersionLabel(String text, boolean instantAppend) {
        try {
            JLabel label = GUIHelper.getLabel(text, 1, 14, Color.WHITE);
            label.setBorder(BorderFactory.createEmptyBorder(13, 8, 6, 8));
            if (instantAppend) {
                this.changelogPanel.add(label);
            } else {
                this.labels.put(this.labelCount, label);
                ++this.labelCount;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void createTextLabel(String text) {
        try {
            JLabel label = GUIHelper.getLabel("<html><div width=\"670\">" + text + "</div></html>", 0, 13, Color.WHITE);
            label.setBorder(BorderFactory.createEmptyBorder(1, 18, 2, 8));
            label.setVerticalAlignment(1);
            label.setVerticalTextPosition(1);
            ResourceHelper.setComponentIcon(label, "circle-changelog.png", 8, 11);
            this.labels.put(this.labelCount, label);
            ++this.labelCount;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void appendLabels() {
        try {
            if (!this.labels.isEmpty()) {
                for (Map.Entry<Integer, JLabel> entry : this.labels.entrySet()) {
                    this.changelogPanel.add(entry.getValue());
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public static enum Changelog {
        AddOn,
        Client;

    }
}

