/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client.threads;

import com.hub.eso.client.ClientGUI;
import com.hub.eso.client.language.LanguageHandler;
import com.hub.eso.client.storage.AddOnTransferMeta;
import com.hub.eso.client.threads.Cronjob;
import com.hub.eso.client.threads.Threads;
import com.hub.eso.client.threads.TransferWorker;
import com.hub.eso.client.threads.UserAutoLogin;
import com.hub.eso.client.utils.ExceptionHandler;
import com.hub.eso.client.utils.Function;
import com.hub.eso.client.utils.Settings;
import com.hub.eso.client.vars.Const;
import com.hub.eso.client.web.WebClass;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;

public class InitApplication
implements Runnable {
    protected final ClientGUI mainGUI;
    protected final WebClass web;
    protected final LanguageHandler lang;
    protected final boolean showDashboard;

    public InitApplication(ClientGUI mainGUI, boolean showDashboard) {
        this.mainGUI = mainGUI;
        this.web = mainGUI.getWebClass();
        this.lang = mainGUI.getLanguageHandler();
        this.showDashboard = showDashboard;
    }

    @Override
    public void run() {
        try {
            if (!Threads.getInstance().addThreadToStack(Thread.currentThread().getName(), Thread.currentThread())) {
                return;
            }
            while (!this.web.internetConnectionStatus()) {
                this.mainGUI.setInternetStatusPanel(true, this.lang.getTex("inet_no_connection_title"), this.lang.getTex("inet_no_connection_text"));
                Thread.sleep(2000L);
            }
            this.mainGUI.setInternetStatusPanel(false, "", "");
            if (this.showDashboard) {
                this.mainGUI.showDashboardPanel();
            }
            if (!this.mainGUI.getUser().getUserToken().isEmpty()) {
                this.mainGUI.setWorkingPanel(true, this.lang.getTex("notify_auto_login"), this.lang.getTex("notify_login_text"), "loading.gif", false, null);
                Thread addOnStatusThread = new Thread(new UserAutoLogin());
                addOnStatusThread.setName("auto_login");
                addOnStatusThread.setDaemon(true);
                addOnStatusThread.start();
            } else {
                this.mainGUI.setLoginNoticePanel(true);
            }
            Thread addonWorkerThread = new Thread(new Cronjob());
            addonWorkerThread.setName("cronjob");
            addonWorkerThread.setDaemon(true);
            addonWorkerThread.start();
            this.initAddOnFileWatcher();
            Threads.getInstance().removeThreadFromStack(Thread.currentThread().getName());
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void initAddOnFileWatcher() {
        try {
            Settings settings = this.mainGUI.getSettings();
            String esoDataDir = settings.getValue("ESODataDir");
            if (!esoDataDir.isEmpty() && Function.fileExists(esoDataDir)) {
                String megaserverSavedVariablesPath = esoDataDir + Const.ESO_SV_LIVE_DIR;
                final InitApplication self = this;
                FileAlterationObserver observer = new FileAlterationObserver(megaserverSavedVariablesPath);
                FileAlterationMonitor monitor = new FileAlterationMonitor(2500L, observer);
                FileAlterationListenerAdaptor fal = new FileAlterationListenerAdaptor(this){

                    @Override
                    public void onFileChange(File file) {
                        self.startFileTransfer(file);
                    }

                    @Override
                    public void onFileCreate(File file) {
                        self.startFileTransfer(file);
                    }
                };
                observer.addListener(fal);
                monitor.start();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void startFileTransfer(File file) {
        try {
            HashMap<String, String> addOnFiles = AddOnTransferMeta.getInstance().getAddOnFiles();
            if (!addOnFiles.isEmpty()) {
                String fileName = FilenameUtils.getName(file.toString());
                for (Map.Entry<String, String> me : addOnFiles.entrySet()) {
                    if (!me.getKey().equals(fileName)) continue;
                    String folderName = AddOnTransferMeta.getInstance().getFolderName(fileName);
                    Thread transferThread = new Thread(new TransferWorker(file, me.getValue(), folderName));
                    transferThread.setName("transfer_thread_" + me.getKey());
                    transferThread.setDaemon(true);
                    transferThread.start();
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }
}

