/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client.threads;

import com.hub.eso.client.ClientGUI;
import com.hub.eso.client.components.JAddOnPanel;
import com.hub.eso.client.exceptions.AddonInstallException;
import com.hub.eso.client.language.LanguageHandler;
import com.hub.eso.client.threads.AddOnPanelBuilder;
import com.hub.eso.client.threads.SetAddOnVersions;
import com.hub.eso.client.threads.Threads;
import com.hub.eso.client.utils.AddOnPanelHelper;
import com.hub.eso.client.utils.ExceptionHandler;
import com.hub.eso.client.utils.Function;
import com.hub.eso.client.utils.Settings;
import com.hub.eso.client.web.WebClass;
import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.progress.ProgressMonitor;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class InstallAddOn
implements Runnable {
    protected final ClientGUI mainGUI = ClientGUI.getInstance();
    protected final LanguageHandler lang = this.mainGUI.getLanguageHandler();
    protected final boolean autoUpdate;
    protected final String addonName;
    protected final String folderName;
    protected final String file;
    protected final String fileChecksum;
    protected final Settings settings = this.mainGUI.getSettings();
    protected final AddOnPanelHelper addOnPanelHelper;

    public InstallAddOn(boolean autoUpdate, String addonName, String folderName, String file, String fileChecksum) {
        this.autoUpdate = autoUpdate;
        this.addonName = addonName;
        this.folderName = folderName;
        this.file = file;
        this.fileChecksum = fileChecksum;
        this.addOnPanelHelper = new AddOnPanelHelper();
    }

    @Override
    public void run() {
        try {
            if (!Threads.getInstance().addThreadToStack(Thread.currentThread().getName(), Thread.currentThread())) {
                return;
            }
            String esoDataDir = this.settings.getValue("ESODataDir");
            String liveDataPath = esoDataDir + File.separator + "live";
            String addOnsPath = liveDataPath + File.separator + "AddOns";
            if (Function.dirExists(esoDataDir)) {
                if (Function.dirExists(liveDataPath)) {
                    File addOnsDir = new File(addOnsPath);
                    if (!addOnsDir.exists()) {
                        addOnsDir.mkdirs();
                    }
                    URI uriObj = new URI(this.file);
                    String tempFile = Function.getTempPath() + Paths.get(uriObj.getPath(), new String[0]).getFileName().toString();
                    Function.rmFile(tempFile);
                    WebClass web = new WebClass(this.lang);
                    JAddOnPanel addonPanel = this.addOnPanelHelper.getJAddonPanel(this.folderName);
                    web.addDownloadListener((bytesRead, bytesTotal, percentCompleted) -> {
                        String statusText = StringUtils.replace(this.lang.getTex("addon_install_download_progress"), "%bytes_read%", Function.bytesToHuman(bytesRead));
                        statusText = StringUtils.replace(statusText, "%bytes_total%", Function.bytesToHuman(bytesTotal));
                        statusText = StringUtils.replace(statusText, "%percent%", Integer.toString(percentCompleted));
                        addonPanel.setStatus(5);
                        addonPanel.setStatusText(statusText);
                        addonPanel.setProgressBar(percentCompleted, true);
                    });
                    addonPanel.setProgressBar(0, true);
                    if (web.downloadFileBinary(this.file + "?user_token=" + this.mainGUI.getUser().getUserToken(), tempFile).booleanValue()) {
                        addonPanel.setStatus(6);
                        String localFileChecksum = Function.getFileChecksum(tempFile, "SHA-256");
                        if (localFileChecksum.equals(this.fileChecksum)) {
                            FileUtils.deleteDirectory(new File(addOnsPath + File.separator + this.folderName));
                            try {
                                ZipFile zipFile = new ZipFile(tempFile);
                                ProgressMonitor progressMonitor = zipFile.getProgressMonitor();
                                zipFile.setRunInThread(true);
                                zipFile.extractAll(addOnsPath);
                                while (!progressMonitor.getState().equals((Object)ProgressMonitor.State.READY)) {
                                    addonPanel.setStatusText(StringUtils.replace(this.lang.getTex("addon_install_unzip_progress"), "%percent%", Integer.toString(progressMonitor.getPercentDone())));
                                    addonPanel.setProgressBar(progressMonitor.getPercentDone(), true);
                                }
                            }
                            catch (Exception e) {
                                ExceptionHandler.handle(e);
                                this.mainGUI.showNotification(this.lang.getTex("addon_install_error_addon_extraction_failed_title"), StringUtils.replace(this.lang.getTex("addon_install_error_addon_extraction_failed_text"), "%addon_name%", this.addonName));
                            }
                            Function.rmFile(tempFile);
                            addonPanel.setLocalVersionInt(AddOnPanelBuilder.getAddonVersionFromFile(addOnsPath + File.separator + this.folderName + File.separator + this.folderName + ".txt"));
                            addonPanel.setLocalVersionStr(AddOnPanelBuilder.getAddonVersionStringFromFile(addOnsPath + File.separator + this.folderName + File.separator + this.folderName + ".txt"));
                            addonPanel.setStatus(1);
                            Thread addonVersionThread = new Thread(new SetAddOnVersions());
                            addonVersionThread.setName("set_addon_versions_thread");
                            addonVersionThread.setDaemon(true);
                            addonVersionThread.start();
                            if (this.autoUpdate) {
                                String notificationText = StringUtils.replace(this.lang.getTex("addon_update_text"), "%addon_name%", addonPanel.getAddOnName());
                                notificationText = StringUtils.replace(notificationText, "%version%", addonPanel.getLocalVersionStr());
                                this.mainGUI.showNotification(this.lang.getTex("addon_update_title"), notificationText);
                            }
                        } else {
                            ExceptionHandler.handle(new AddonInstallException("Update file checksum mismatch:\nFile: " + this.file + "\nFilename: " + new File(this.file).getName() + "\nSource Checksum: " + this.fileChecksum + "\nLocal Checksum: " + localFileChecksum + "\n"));
                            addonPanel.setStatus(1);
                            this.mainGUI.showNotification(this.lang.getTex("addon_install_error_addon_download_failed_title"), StringUtils.replace(this.lang.getTex("addon_install_error_addon_download_failed_text"), "%addon_name%", this.addonName));
                        }
                    } else {
                        addonPanel.setStatus(1);
                        this.mainGUI.showNotification(this.lang.getTex("addon_install_error_addon_download_failed_title"), StringUtils.replace(this.lang.getTex("addon_install_error_addon_download_failed_text"), "%addon_name%", this.addonName));
                    }
                } else {
                    this.mainGUI.showNotification(this.lang.getTex("addon_install_error_no_live_data_dir_title"), this.lang.getTex("addon_install_error_no_live_data_dir_text"));
                }
            } else {
                this.mainGUI.showNotification(this.lang.getTex("addon_install_error_no_data_dir_title"), this.lang.getTex("addon_install_error_no_data_dir_text"));
            }
            Threads.getInstance().removeThreadFromStack(Thread.currentThread().getName());
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }
}

