/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client.threads;

import com.hub.eso.client.ClientGUI;
import com.hub.eso.client.User;
import com.hub.eso.client.components.JAddOnPanel;
import com.hub.eso.client.threads.Threads;
import com.hub.eso.client.utils.ExceptionHandler;
import com.hub.eso.client.web.WebClass;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JPanel;

public class SetAddOnVersions
implements Runnable {
    protected final WebClass web;
    protected final User user;

    public SetAddOnVersions() {
        ClientGUI mainGUI = ClientGUI.getInstance();
        this.web = mainGUI.getWebClass();
        this.user = mainGUI.getUser();
    }

    @Override
    public void run() {
        try {
            if (!Threads.getInstance().addThreadToStack(Thread.currentThread().getName(), Thread.currentThread())) {
                return;
            }
            if (!this.user.getUserToken().isEmpty()) {
                Component[] addons;
                HashMap<String, String> params = new HashMap<String, String>();
                ClientGUI mainUI = ClientGUI.getInstance();
                JPanel addonsPanel = mainUI.getAddonsItemsPanel();
                if (addonsPanel != null && (addons = addonsPanel.getComponents()).length > 0) {
                    for (Component comp : addons) {
                        if (!(comp instanceof JAddOnPanel)) continue;
                        JAddOnPanel panel = (JAddOnPanel)comp;
                        params.put("addon_versions[" + panel.getAddonFolderName() + "]", panel.getLocalVersionStr());
                    }
                    params.put("token", this.user.getUserToken());
                    this.web.apiCall(WebClass.Call.SetAddOnVersions, params);
                }
            }
            Threads.getInstance().removeThreadFromStack(Thread.currentThread().getName());
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }
}

