/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client.threads;

import com.hub.eso.client.ClientGUI;
import com.hub.eso.client.User;
import com.hub.eso.client.language.LanguageHandler;
import com.hub.eso.client.threads.SetAddOnVersions;
import com.hub.eso.client.threads.Threads;
import com.hub.eso.client.utils.ExceptionHandler;
import com.hub.eso.client.web.ApiResult;
import com.hub.eso.client.web.WebClass;
import java.util.HashMap;
import org.json.JSONObject;

class UserAutoLogin
implements Runnable {
    protected final ClientGUI mainGUI = ClientGUI.getInstance();
    protected final WebClass web = this.mainGUI.getWebClass();
    protected final LanguageHandler lang = this.mainGUI.getLanguageHandler();
    protected final User user = this.mainGUI.getUser();

    @Override
    public void run() {
        try {
            String statusText;
            if (!Threads.getInstance().addThreadToStack(Thread.currentThread().getName(), Thread.currentThread())) {
                return;
            }
            boolean isError = true;
            boolean validToken = false;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("token", this.user.getUserToken());
            ApiResult resp = this.web.apiCall(WebClass.Call.LoginToken, params);
            if (resp != null) {
                statusText = resp.getStatusText();
                if (resp.getStatus() == ApiResult.ApiStatus.OK) {
                    JSONObject respData = resp.getData();
                    if (!respData.has("id")) {
                        statusText = this.lang.getTex("api_request_failed");
                    } else if (!respData.has("token")) {
                        statusText = this.lang.getTex("api_request_failed");
                    } else if (!respData.has("secure_id")) {
                        statusText = this.lang.getTex("api_request_failed");
                    } else if (!respData.has("username")) {
                        statusText = this.lang.getTex("api_request_failed");
                    } else {
                        isError = false;
                        validToken = true;
                        this.user.setUserName(respData.getString("username"));
                        this.user.setUserSecureID(respData.getString("secure_id"));
                        this.user.setUserToken(respData.getString("token"));
                        Thread addonVersionThread = new Thread(new SetAddOnVersions());
                        addonVersionThread.setName("set_addon_versions_thread");
                        addonVersionThread.setDaemon(true);
                        addonVersionThread.start();
                    }
                } else {
                    isError = false;
                }
            } else {
                statusText = this.lang.getTex("api_request_failed");
            }
            if (!isError && !validToken) {
                this.user.logout();
                this.mainGUI.setWorkingPanel(true, this.lang.getTex("login_error_title"), this.lang.getTex("login_session_invalid"), "times.png", true, null);
                this.mainGUI.showNotification(this.lang.getTex("login_error_title"), this.lang.getTex("login_session_invalid"));
            } else if (isError) {
                this.user.logout();
                this.mainGUI.setWorkingPanel(true, this.lang.getTex("login_error_title"), statusText, "times.png", true, null);
            } else {
                this.mainGUI.setAccountName();
                this.mainGUI.setWorkingPanel(false, "", "", "", false, null);
                this.mainGUI.setLoginNoticePanel(false);
                this.mainGUI.showAccountPanel(User.UserLoginState.LOGGED_IN);
            }
            Threads.getInstance().removeThreadFromStack(Thread.currentThread().getName());
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }
}

