/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client.utils;

import com.hub.eso.client.ClientGUI;
import com.hub.eso.client.utils.ExceptionHandler;
import com.hub.eso.client.utils.Function;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

public class Autostart {
    protected static final String osShort = Function.getShortOSName();
    protected static final String osxLaunchdLibraryPath = System.getProperty("user.home") + "/Library/LaunchAgents/com.hub.eso.client.plist";
    protected static boolean minimized;

    public static void enableAutostart(boolean minimized) {
        try {
            Autostart.minimized = minimized;
            switch (osShort) {
                case "windows": {
                    Autostart.enableWindowsAutostart();
                    break;
                }
                case "mac": {
                    Autostart.enableMacAutostart();
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public static boolean getAutostartStatus() {
        boolean status = false;
        try {
            switch (osShort) {
                case "windows": {
                    status = Autostart.getWindowsAutostartStatus();
                    break;
                }
                case "mac": {
                    status = Autostart.getMacAutostartStatus();
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        return status;
    }

    public static void disableAutostart() {
        try {
            switch (osShort) {
                case "windows": {
                    Autostart.disableWindowsAutostart();
                    break;
                }
                case "mac": {
                    Autostart.disableMacAutostart();
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected static void enableWindowsAutostart() {
        try {
            String jarFilePath = Function.getJarPath();
            String nativeDir = jarFilePath.substring(0, jarFilePath.lastIndexOf(File.separator));
            if (!nativeDir.isEmpty()) {
                String value = "\"" + nativeDir + "\\eso_hub_client.exe\" -minimized";
                Advapi32Util.registrySetStringValue(WinReg.HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Run", "ESOHubClientJava", value);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected static void enableMacAutostart() {
        try {
            String appPath = Function.getMacOSAppPath();
            if (osShort.equals("mac") && System.getenv("DEV") != null) {
                appPath = "/Applications/ESO-Hub Client.app";
            }
            if (appPath != null) {
                String inputLine;
                StringBuilder strBuilder = new StringBuilder();
                URL plistURL = ClientGUI.class.getResource("/osx/launchd.plist");
                BufferedReader in = new BufferedReader(new InputStreamReader(plistURL.openStream()));
                while ((inputLine = in.readLine()) != null) {
                    if (inputLine.contains("{APP_PATH}")) {
                        inputLine = StringUtils.replace(inputLine, "{APP_PATH}", appPath);
                    } else if (inputLine.contains("{MINIMIZED_PLACEHOLDER}")) {
                        inputLine = minimized ? StringUtils.replace(inputLine, "{MINIMIZED_PLACEHOLDER}", "<string>--args</string>\n<string>-minimized</string>") : StringUtils.replace(inputLine, "{MINIMIZED_PLACEHOLDER}", "");
                    }
                    strBuilder.append(inputLine);
                    strBuilder.append(System.lineSeparator());
                }
                in.close();
                BufferedWriter writer = new BufferedWriter(new FileWriter(osxLaunchdLibraryPath));
                writer.write(strBuilder.toString());
                writer.close();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected static void disableWindowsAutostart() {
        try {
            Advapi32Util.registryDeleteValue(WinReg.HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Run", "ESOHubClientJava");
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected static void disableMacAutostart() {
        try {
            new File(osxLaunchdLibraryPath).delete();
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected static boolean getWindowsAutostartStatus() {
        boolean status = false;
        try {
            String value = Advapi32Util.registryGetStringValue(WinReg.HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Run", "ESOHubClientJava");
            if (value != null) {
                status = true;
            }
        }
        catch (Win32Exception e) {
            status = false;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        return status;
    }

    protected static boolean getMacAutostartStatus() {
        boolean status = false;
        try {
            status = Function.fileExists(osxLaunchdLibraryPath);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        return status;
    }
}

