/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client.utils;

import com.hub.eso.client.utils.Function;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class ExceptionHandler {
    protected static String OS;

    public static void handle(Exception err) {
        try {
            if (err instanceof InterruptedException) {
                return;
            }
            if (OS == null) {
                OS = Function.getShortOSName();
            }
            String logFolderPath = Function.getLogFolderForOS();
            String lineSeperator = System.lineSeparator();
            File dir = new File(logFolderPath);
            dir.mkdirs();
            boolean addLogHeader = false;
            SimpleDateFormat logFileDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat logMsgDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date today = Calendar.getInstance().getTime();
            File errFile = new File(logFolderPath, logFileDateFormat.format(today) + ".txt");
            if (errFile.createNewFile()) {
                addLogHeader = true;
            }
            FileWriter errFileWriter = new FileWriter(errFile, true);
            if (addLogHeader) {
                errFileWriter.write("##" + lineSeperator + "# Client Version: 1.0.9" + lineSeperator + "# Client Build: 10144" + lineSeperator + "# OS Name: " + System.getProperty("os.name") + lineSeperator + "# OS Version: " + System.getProperty("os.version") + lineSeperator + "# OS Architecture: " + System.getProperty("sun.arch.data.model") + lineSeperator + "# OS Language: " + System.getProperty("user.language") + lineSeperator + "# Java Version: " + System.getProperty("java.version") + lineSeperator + "##" + lineSeperator + lineSeperator);
            }
            errFileWriter.write("-- Date: " + logMsgDateFormat.format(today) + lineSeperator + "-- Class: " + err.getClass().getCanonicalName() + lineSeperator + ExceptionHandler.stringstackTraceToString(err) + lineSeperator + lineSeperator);
            errFileWriter.flush();
            errFileWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static String stringstackTraceToString(Exception err) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            err.printStackTrace(pw);
            return sw.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }
}

