/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client.utils;

import com.hub.eso.client.ESOHubClient;
import com.hub.eso.client.utils.ExceptionHandler;
import com.hub.eso.client.vars.Const;
import com.sun.jna.Platform;
import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JFileChooser;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class Function {
    public static final String OS_WINDOWS = "windows";
    public static final String OS_MAC = "mac";
    public static final String OS_LINUX = "linux";
    public static final String OS_UNKNOWN = "unknown";
    public static String osShortName;

    public static String getWorkingDirectory() {
        Path currentRelativePath = Paths.get("", new String[0]);
        return currentRelativePath.toAbsolutePath().toString();
    }

    public static String getTempPath() {
        Object path = "";
        try {
            path = FileUtils.getTempDirectory().getAbsolutePath();
            if (!((String)path).substring(((String)path).length() - 1).equals(File.separator)) {
                path = (String)path + File.separator;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        return path;
    }

    public static String getJarPath() {
        try {
            return new File(ESOHubClient.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getAbsolutePath();
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return "";
        }
    }

    public static String getJreJavaBin() {
        return System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
    }

    public static String getMacOSAppPath() {
        String path = null;
        try {
            String libPath = System.getProperty("java.home");
            if (libPath.contains(".app")) {
                int endPos = libPath.indexOf(".app") + 4;
                path = libPath.substring(0, endPos);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        return path;
    }

    public static String getLogFolderForOS() {
        String os = Function.getShortOSName();
        if (os.equals(OS_WINDOWS)) {
            return System.getenv("APPDATA") + File.separator + "ESO-Hub-Client" + File.separator + "logs";
        }
        if (os.equals(OS_MAC)) {
            String osxAppPath = System.getenv("HOME") + File.separator + ".eso_hub_client";
            File dir = new File(osxAppPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            return osxAppPath + File.separator + "logs";
        }
        String appPath = System.getProperty("user.home") + File.separator + ".eso_hub_client";
        File dir = new File(appPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return appPath + File.separator + "logs";
    }

    public static String getUpdateFolderForOS() {
        try {
            String os = Function.getShortOSName();
            if (os.equals(OS_WINDOWS)) {
                return System.getenv("APPDATA") + File.separator + "ESO-Hub-Client" + File.separator + "update";
            }
            if (os.equals(OS_MAC)) {
                String osxAppPath = System.getenv("HOME") + File.separator + ".eso_hub_client";
                File dir = new File(osxAppPath);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                return osxAppPath + File.separator + "update";
            }
            String appPath = System.getProperty("user.home") + File.separator + ".eso_hub_client";
            File dir = new File(appPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            return appPath + File.separator + "update";
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return "update";
        }
    }

    public static String getOsxNotificationWrapperPath() {
        String osxAppPath = Function.getMacOSAppPath();
        if (System.getenv("DEV") != null) {
            osxAppPath = "/Applications/ESO-Hub Client.app";
        }
        return osxAppPath + File.separator + "Contents" + File.separator + "MacOS" + File.separator + "usernotification";
    }

    public static String getOsxJavaAppLauncherPath() {
        String osxAppPath = Function.getMacOSAppPath();
        if (System.getenv("DEV") != null) {
            osxAppPath = "/Applications/ESO-Hub Client.app";
        }
        return osxAppPath + File.separator + "Contents" + File.separator + "MacOS" + File.separator + "JavaAppLauncher";
    }

    public static String getESODataDir() {
        String esoDataDirDE;
        String esoDataDir = "";
        String osName = Function.getShortOSName();
        String currentUsersHomeDir = System.getProperty("user.home");
        String esoDataDirEN = switch (osName) {
            case OS_WINDOWS -> esoDataDirDE = currentUsersHomeDir + File.separator + "Documents" + File.separator + "Elder Scrolls Online";
            case OS_MAC -> esoDataDirDE = System.getProperty("user.home") + File.separator + "Documents" + File.separator + "Elder Scrolls Online";
            default -> {
                esoDataDirDE = currentUsersHomeDir + File.separator + "Dokumente" + File.separator + "Elder Scrolls Online";
                yield currentUsersHomeDir + File.separator + "Documents" + File.separator + "Elder Scrolls Online";
            }
        };
        File dataDirDE = new File(esoDataDirDE + Const.ESO_SV_LIVE_DIR);
        File dataDirEN = new File(esoDataDirEN + Const.ESO_SV_LIVE_DIR);
        if (dataDirDE.exists()) {
            esoDataDir = StringUtils.replace(dataDirDE.getAbsolutePath(), Const.ESO_SV_LIVE_DIR, "");
        } else if (dataDirEN.exists()) {
            esoDataDir = StringUtils.replace(dataDirEN.getAbsolutePath(), Const.ESO_SV_LIVE_DIR, "");
        }
        return esoDataDir;
    }

    public static String getShortOSName() {
        try {
            String osShortName;
            if (Function.osShortName == null) {
                osShortName = Platform.isWindows() ? OS_WINDOWS : (Platform.isMac() ? OS_MAC : (Platform.isLinux() ? OS_LINUX : OS_UNKNOWN));
                Function.osShortName = osShortName;
            } else {
                osShortName = Function.osShortName;
            }
            return osShortName;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return "";
        }
    }

    public static void openLink(String link) {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(link));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public static void openPath(String path) {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().open(new File(path));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public static String bytesToHuman(long bytes) {
        try {
            if (bytes > 0L) {
                String[] units = new String[]{"B", "KB", "MB", "GB", "TB", "PB"};
                DecimalFormat df = new DecimalFormat("#,##0.##");
                df.setMaximumFractionDigits(2);
                df.setMinimumFractionDigits(2);
                int digitGroups = (int)(Math.log10(bytes) / Math.log10(1024.0));
                return df.format((double)bytes / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        return "0 B";
    }

    public static String numberFormat(long number, int comma) {
        try {
            Locale currentLocale = Locale.getDefault();
            NumberFormat formatter = NumberFormat.getNumberInstance(currentLocale);
            formatter.setMaximumFractionDigits(comma);
            formatter.setMinimumFractionDigits(comma);
            return formatter.format(number);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return "";
        }
    }

    public static String getFormatedDate(long date) {
        try {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 2, Locale.getDefault());
            return dateFormat.format(date);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return "";
        }
    }

    public static String openFileChooser(Component parent, int type, String approveText, String currentDirPath) {
        try {
            String path = null;
            JFileChooser chooser = new JFileChooser();
            if (!currentDirPath.isEmpty()) {
                chooser.setCurrentDirectory(new File(currentDirPath));
            }
            chooser.setDialogType(0);
            chooser.setFileSelectionMode(type);
            chooser.setApproveButtonText(approveText);
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileHidingEnabled(false);
            if (chooser.showOpenDialog(parent) == 0) {
                path = chooser.getSelectedFile().getAbsolutePath();
            }
            return path;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return "";
        }
    }

    public static boolean fileExists(String filePath) {
        try {
            if (new File(filePath).exists()) {
                return true;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        return false;
    }

    public static boolean dirExists(String dataPath) {
        try {
            if (new File(dataPath).exists()) {
                return true;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        return false;
    }

    public static void rmFile(String path) {
        try {
            File file = new File(path);
            if (new File(path).exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public static String getFileChecksum(String file, String algo) {
        String checksum = "";
        try {
            int bytesCount;
            byte[] byteArray = new byte[1024];
            MessageDigest digest = MessageDigest.getInstance(algo);
            FileInputStream fis = new FileInputStream(file);
            while ((bytesCount = fis.read(byteArray)) != -1) {
                digest.update(byteArray, 0, bytesCount);
            }
            fis.close();
            byte[] bytes = digest.digest();
            StringBuilder sb = new StringBuilder();
            for (byte aByte : bytes) {
                sb.append(Integer.toString((aByte & 0xFF) + 256, 16).substring(1));
            }
            checksum = sb.toString();
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        return checksum;
    }

    public static String getTrayIconPath() {
        String iconPath = OS_MAC.equals(Function.getShortOSName()) ? "/trayicon/mac.png" : "/trayicon/default.png";
        return iconPath;
    }
}

