/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client.utils;

import com.hub.eso.client.utils.Autostart;
import com.hub.eso.client.utils.ExceptionHandler;
import java.util.prefs.Preferences;

public class Settings {
    public static final String CONF_LANG = "Lang";
    public static final String CONF_ESO_DATA_DIR = "ESODataDir";
    public static final String CONF_USER_AUTH_TOKEN = "UserAuthToken";
    public static final String CONF_TRANSFERRED_BYTES = "TransferredBytes";
    public static final String CONF_TRANSFERRED_FILES = "TransferredFiles";
    public static final String CONF_MINIMIZE_TO_TRAY = "MinimizeToTray";
    public static final String CONF_AUTOSTART = "Autostart";
    public static final String CONF_SHOW_NOTIFICATIONS = "ShowNotifications";
    public static final String CONF_COMPRESSION_LEVEL = "CompressionLevel";
    public static final String CONF_LAST_SENT_ADDON = "LastSentAddOn";
    public static final String CONF_ADDON_ENABLED = "AddOnEnabled";
    protected Preferences prefs;
    protected boolean isNewConfig = false;

    public Settings() {
        try {
            this.prefs = Preferences.userRoot().node("/com/hub/eso/client/settings");
            String autoStartDefaultValue = "1";
            if (this.prefs.get(CONF_LANG, "").isEmpty()) {
                this.isNewConfig = true;
                autoStartDefaultValue = Autostart.getAutostartStatus() ? "1" : "0";
            }
            this.createValue(CONF_LANG, "");
            this.createValue(CONF_ESO_DATA_DIR, "");
            this.createValue(CONF_USER_AUTH_TOKEN, "");
            this.createValue(CONF_TRANSFERRED_BYTES, "0");
            this.createValue(CONF_TRANSFERRED_FILES, "0");
            this.createValue(CONF_MINIMIZE_TO_TRAY, "1");
            this.createValue(CONF_AUTOSTART, autoStartDefaultValue);
            this.createValue(CONF_SHOW_NOTIFICATIONS, "1");
            this.createValue(CONF_COMPRESSION_LEVEL, "9");
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public boolean isNewConfig() {
        return this.isNewConfig;
    }

    public synchronized void setValue(String key, String value) {
        try {
            this.prefs.put(key, value);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public synchronized String getValue(String key) {
        try {
            return this.prefs.get(key, "");
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return "";
        }
    }

    protected void createValue(String key, String defaultValue) {
        try {
            String value = this.prefs.get(key, "");
            if (value.isEmpty()) {
                this.setValue(key, defaultValue);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }
}

