/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.updater;

import com.hub.eso.client.threads.UpdateCheck;
import com.hub.eso.client.utils.ExceptionHandler;
import com.hub.eso.client.utils.Function;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;

public class Updater {
    protected final String osxAppPath;
    protected final String updateFolderPath;
    protected final String updateFilesFolderPath;
    protected final String updateMetaFilePath;

    public Updater(String osxAppPath) {
        this.osxAppPath = osxAppPath;
        this.updateFolderPath = Function.getUpdateFolderForOS();
        this.updateFilesFolderPath = this.updateFolderPath + File.separator + "files";
        this.updateMetaFilePath = this.updateFolderPath + File.separator + "update.json";
        try {
            JSONObject meta = UpdateCheck.getUpdateMetaInfo();
            if (meta != null) {
                this.applyUpdate();
                UpdateCheck.cleanupUpdateDirectory();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void closeClientUnix() {
        try {
            String line;
            Process p = Runtime.getRuntime().exec("ps -eo pid,comm");
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                if (!line.contains("/Contents/MacOS/JavaAppLauncher")) continue;
                int pid = this.getClientProcessIdUnix(line);
                if (pid <= 0) break;
                Runtime.getRuntime().exec("kill -9 " + pid);
                break;
            }
            input.close();
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected int getClientProcessIdUnix(String execLine) {
        int pid = 0;
        try {
            String appPlistFilePath;
            int end;
            String appFolderPath;
            String[] pathParts = execLine.split(" ", 2);
            if (pathParts.length >= 2 && Function.dirExists(appFolderPath = pathParts[1].substring(0, end = pathParts[1].indexOf(".app") + 4)) && Function.fileExists(appPlistFilePath = appFolderPath + File.separator + "Contents" + File.separator + "Info.plist")) {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(appPlistFilePath));
                while ((line = br.readLine()) != null) {
                    if (!line.contains("com.hub.eso.client")) continue;
                    pid = Integer.parseInt(pathParts[0]);
                    break;
                }
                br.close();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        return pid;
    }

    protected void applyUpdate() {
        try {
            String os = Function.getShortOSName();
            if (Function.fileExists(this.updateMetaFilePath)) {
                Function.rmFile(this.updateMetaFilePath);
            }
            if (os.equals("mac")) {
                this.applyUpdateOSX();
                this.closeClientUnix();
                this.runClientOSX();
            } else {
                this.applyUpdateJar();
                this.closeClientUnix();
                this.runClientJar();
            }
            System.exit(0);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void runClientOSX() {
        try {
            if (this.osxAppPath != null) {
                Runtime.getRuntime().exec(new String[]{"open", this.osxAppPath});
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void runClientJar() {
        try {
            String jarName = System.getProperty("java.class.path");
            String destPath = Function.getWorkingDirectory() + File.separator + jarName;
            Runtime.getRuntime().exec(new String[]{Function.getJreJavaBin(), "-jar", destPath});
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void applyUpdateOSX() {
        try {
            String osxAppLauncher = Function.getOsxJavaAppLauncherPath();
            String osxNotificationWrapper = Function.getOsxNotificationWrapperPath();
            FileUtils.copyDirectory(new File(this.updateFilesFolderPath + File.separator + "ESO-Hub Client.app"), new File(this.osxAppPath));
            Runtime.getRuntime().exec(new String[]{"chmod", "u+x", osxAppLauncher});
            Runtime.getRuntime().exec(new String[]{"chmod", "u+x", osxNotificationWrapper});
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void applyUpdateJar() {
        try {
            String jarName = System.getProperty("java.class.path");
            String srcPath = this.updateFilesFolderPath + File.separator + "eso_hub_client.jar";
            String destPath = Function.getWorkingDirectory() + File.separator + jarName;
            FileUtils.copyFile(new File(srcPath), new File(destPath));
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }
}

