/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client.components;

import com.hub.eso.client.utils.ExceptionHandler;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;

public class JGradientButton
extends JButton {
    protected Color colorStart;
    protected Color colorEnd;
    protected Color colorHoverStart;
    protected Color colorHoverEnd;
    protected Color colorCurStart;
    protected Color colorCurEnd;
    protected static final Color DISABLED_START_COLOR = Color.GRAY;
    protected static final Color DISABLED_END_COLOR = Color.DARK_GRAY;

    public JGradientButton(Color colorStart, Color colorEnd, Color colorHoverStart, Color colorHoverEnd) {
        super("Gradient Button");
        try {
            this.colorStart = colorStart;
            this.colorEnd = colorEnd;
            this.colorCurStart = colorStart;
            this.colorCurEnd = colorEnd;
            this.colorHoverStart = colorHoverStart;
            this.colorHoverEnd = colorHoverEnd;
            this.setContentAreaFilled(false);
            this.setFocusPainted(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    JGradientButton.this.colorCurStart = JGradientButton.this.colorHoverStart;
                    JGradientButton.this.colorCurEnd = JGradientButton.this.colorHoverEnd;
                    JGradientButton.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    JGradientButton.this.colorCurStart = JGradientButton.this.colorStart;
                    JGradientButton.this.colorCurEnd = JGradientButton.this.colorEnd;
                    JGradientButton.this.repaint();
                }
            });
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        try {
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.isEnabled()) {
                g2.setPaint(new GradientPaint(new Point(0, 0), this.colorCurStart, new Point(0, this.getHeight()), this.colorCurEnd));
            } else {
                g2.setPaint(new GradientPaint(new Point(0, 0), DISABLED_START_COLOR, new Point(0, this.getHeight()), DISABLED_END_COLOR));
            }
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.dispose();
            super.paintComponent(g);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }
}

