/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client.threads;

import com.hub.eso.client.ClientGUI;
import com.hub.eso.client.User;
import com.hub.eso.client.components.JAddOnPanel;
import com.hub.eso.client.storage.AddOnTransferMeta;
import com.hub.eso.client.threads.InstallAddOn;
import com.hub.eso.client.threads.SetAddOnVersions;
import com.hub.eso.client.threads.Threads;
import com.hub.eso.client.utils.AddOnPanelHelper;
import com.hub.eso.client.utils.ExceptionHandler;
import com.hub.eso.client.utils.Function;
import com.hub.eso.client.utils.OldAddOnHandler;
import com.hub.eso.client.utils.Settings;
import com.hub.eso.client.vars.Const;
import com.hub.eso.client.web.ApiResult;
import com.hub.eso.client.web.WebClass;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class AddOnPanelBuilder
implements Runnable {
    protected final ClientGUI mainGUI = ClientGUI.getInstance();
    protected final WebClass web = this.mainGUI.getWebClass();
    protected final User user = this.mainGUI.getUser();
    protected final Settings settings = this.mainGUI.getSettings();
    protected final AddOnTransferMeta addOnTransferMeta = AddOnTransferMeta.getInstance();
    protected final AddOnPanelHelper addOnPanelHelper = new AddOnPanelHelper();

    @Override
    public void run() {
        try {
            if (!Threads.getInstance().addThreadToStack(Thread.currentThread().getName(), Thread.currentThread())) {
                return;
            }
            this.mainGUI.setAddonsPanelRefreshLabelEnabled(false);
            String esoDataDir = AddOnPanelBuilder.getEsoDataDir();
            if (!esoDataDir.isEmpty()) {
                String addOnPath = esoDataDir + File.separator + "AddOns";
                this.checkAddOnFolder(addOnPath);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("user_token", this.user.getUserToken());
                ApiResult resp = this.web.apiCall(WebClass.Call.GetAddOnVersions, params);
                if (resp != null && resp.getStatus() == ApiResult.ApiStatus.OK) {
                    ArrayList<String> availableAddOns = new ArrayList<String>();
                    JSONArray addOns = resp.getData().getJSONArray("addons");
                    int length = addOns.length();
                    for (int i = 0; i < length; ++i) {
                        boolean newPanel = false;
                        JSONObject addon = addOns.getJSONObject(i);
                        JSONObject version = addon.getJSONObject("version");
                        JSONObject addonNames = addon.getJSONObject("addon_name");
                        JSONObject addonDescriptions = addon.getJSONObject("addon_description");
                        String folderName = (String)addon.get("folder_name");
                        String addonPath = addOnPath + File.separator + folderName + File.separator;
                        String localVersionStr = AddOnPanelBuilder.getAddonVersionStringFromFile(addonPath + File.separator + folderName + ".txt");
                        int localVersionInt = AddOnPanelBuilder.getAddonVersionFromFile(addonPath + File.separator + folderName + ".txt");
                        String langCode = this.mainGUI.getLanguageHandler().getLanguage().toString();
                        JAddOnPanel addOnPanel = this.addOnPanelHelper.getJAddonPanel(folderName);
                        if (addOnPanel == null) {
                            addOnPanel = new JAddOnPanel(folderName);
                            newPanel = true;
                        }
                        if (!addon.isNull("transfer")) {
                            JSONObject transfer = addon.getJSONObject("transfer");
                            this.addOnTransferMeta.setAddOn(folderName, transfer.getString("sv_file_name"), transfer.getString("endpoint"));
                            addOnPanel.setSavedVariablesFileName(transfer.getString("sv_file_name"));
                        } else {
                            addOnPanel.disableTransfer();
                        }
                        addOnPanel.setFile(addon.getString("file"));
                        addOnPanel.setFileChecksum(addon.getString("checksum"));
                        addOnPanel.setAddOnName(addonNames.getString(langCode));
                        addOnPanel.setDescription(addonDescriptions.getString(langCode));
                        addOnPanel.setServerVersionInt(version.getInt("integer"));
                        addOnPanel.setServerVersionStr(version.getString("string"));
                        addOnPanel.setLocalVersionInt(localVersionInt);
                        addOnPanel.setLocalVersionStr(localVersionStr);
                        addOnPanel.setDisableable(addon.getBoolean("disableable"));
                        addOnPanel.setTranslations();
                        addOnPanel.setStatusTextFromStatus();
                        addOnPanel.setLastTransfer();
                        addOnPanel.setEnabledStatus();
                        if (newPanel) {
                            this.addOnPanelHelper.addAddOnToPanel(addOnPanel);
                            if (!addon.isNull("transfer")) {
                                this.checkForFileChangeSinceLastRun(addOnPanel, esoDataDir);
                            }
                        }
                        availableAddOns.add(addOnPanel.getAddonFolderName());
                        if (addOnPanel.getAddOnEnabled()) {
                            if (addOnPanel.getLocalVersionInt() >= addOnPanel.getServerVersionInt()) continue;
                            Thread installAddonThread = new Thread(new InstallAddOn(true, addOnPanel.getAddOnName(), addOnPanel.getAddonFolderName(), addOnPanel.getFile(), addOnPanel.getFileChecksum()));
                            installAddonThread.setName("install_addon_" + addOnPanel.getAddonFolderName());
                            installAddonThread.setDaemon(true);
                            installAddonThread.start();
                            continue;
                        }
                        addOnPanel.deleteAddOnFolder();
                    }
                    this.addOnPanelHelper.removeNoExistingPanels(availableAddOns);
                    Thread addonVersionThread = new Thread(new SetAddOnVersions());
                    addonVersionThread.setName("set_addon_versions_thread");
                    addonVersionThread.setDaemon(true);
                    addonVersionThread.start();
                    OldAddOnHandler.RemoveOldAddOn(addOnPath);
                }
            }
            this.mainGUI.setAddonsPanelRefreshLabelEnabled(true);
            Threads.getInstance().removeThreadFromStack(Thread.currentThread().getName());
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public static synchronized String getEsoDataDir() {
        Object dataDir = "";
        try {
            String megaserverDataPath;
            Settings settings = ClientGUI.getInstance().getSettings();
            String esoDataDir = settings.getValue("ESODataDir");
            if (!esoDataDir.isEmpty() && Function.dirExists(megaserverDataPath = esoDataDir + File.separator + "live")) {
                dataDir = megaserverDataPath;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        return dataDir;
    }

    public static int getAddonVersionFromFile(String file) {
        try {
            int version = 0;
            if (Function.fileExists(file)) {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(file));
                while ((line = br.readLine()) != null) {
                    if (!line.startsWith("## IntVersion: ")) continue;
                    version = Integer.parseInt(line.substring(15));
                    break;
                }
                br.close();
            }
            return version;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return 0;
        }
    }

    public static String getAddonVersionStringFromFile(String file) {
        try {
            File fileObj;
            String version = "";
            if (Function.fileExists(file) && (fileObj = new File(file)).exists()) {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(file));
                while ((line = br.readLine()) != null) {
                    if (!line.startsWith("## Version: ")) continue;
                    version = line.substring(12);
                    break;
                }
                br.close();
            }
            return version;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return "";
        }
    }

    protected void checkAddOnFolder(String path) {
        try {
            File addOnDir = new File(path);
            if (!addOnDir.exists()) {
                addOnDir.mkdirs();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void checkForFileChangeSinceLastRun(JAddOnPanel addOnPanel, String esoDataDir) {
        try {
            boolean doTransfer = false;
            String lastSent = this.settings.getValue("LastSentAddOn" + addOnPanel.getAddonFolderName());
            String megaserverSavedVariablesPath = esoDataDir + Const.ESO_SV_LIVE_DIR + File.separator + addOnPanel.getSavedVariablesFileName();
            if (lastSent.isEmpty()) {
                doTransfer = true;
            } else {
                File svFileObj;
                long lastSentLong = Long.parseLong(lastSent);
                if (Function.fileExists(megaserverSavedVariablesPath) && (svFileObj = new File(megaserverSavedVariablesPath)).lastModified() > lastSentLong) {
                    doTransfer = true;
                }
            }
            if (doTransfer) {
                addOnPanel.startTransfer(false);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }
}

