/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client.threads;

import com.hub.eso.client.ClientGUI;
import com.hub.eso.client.components.JComponentStatusPanel;
import com.hub.eso.client.language.LanguageHandler;
import com.hub.eso.client.threads.Threads;
import com.hub.eso.client.utils.ExceptionHandler;
import com.hub.eso.client.utils.Function;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;

public class CheckComponents
implements Runnable {
    protected final ClientGUI mainGUI = ClientGUI.getInstance();
    protected final JPanel checkComponentsItemsPanel = this.mainGUI.getCheckComponentsItemsPanel();
    protected final LanguageHandler lang = this.mainGUI.getLanguageHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (!Threads.getInstance().addThreadToStack(Thread.currentThread().getName(), Thread.currentThread())) {
                return;
            }
            String os = Function.getShortOSName();
            this.checkComponentsItemsPanel.removeAll();
            this.mainGUI.addCheckComponentPanel(this.getComponenetPanel(this.lang.getTex("java_version"), true, System.getProperty("java.version")));
            if (os.equals("windows")) {
                this.setWindowsComponents();
            } else if (os.equals("mac")) {
                this.setMacComponents();
            }
            JPanel jPanel = this.checkComponentsItemsPanel;
            synchronized (jPanel) {
                this.checkComponentsItemsPanel.updateUI();
            }
            Threads.getInstance().removeThreadFromStack(Thread.currentThread().getName());
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected JComponentStatusPanel getComponenetPanel(String name, boolean status, String description) {
        JComponentStatusPanel panel = null;
        try {
            panel = new JComponentStatusPanel(name, status, description);
            int numComponents = this.checkComponentsItemsPanel.getComponentCount();
            int componentsHeight = numComponents * 60;
            int componentsPaddingHeight = numComponents * 4;
            int componentsY = componentsHeight + componentsPaddingHeight;
            panel.setBounds(0, componentsY, 738, 60);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        return panel;
    }

    protected void setWindowsComponents() {
        try {
            String schtasksStatusText;
            boolean schtasksStatus;
            String schtasksUpdaterStatusText;
            boolean schtasksUpdaterStatus;
            if (this.getSchtasksUpdaterStatus()) {
                schtasksUpdaterStatus = true;
                schtasksUpdaterStatusText = "scheduled_updater_task_ok";
            } else {
                schtasksUpdaterStatus = false;
                schtasksUpdaterStatusText = "scheduled_updater_task_error";
            }
            if (this.getSchtasksStatus()) {
                schtasksStatus = true;
                schtasksStatusText = "scheduled_task_cli_ok";
            } else {
                schtasksStatus = false;
                schtasksStatusText = "scheduled_task_cli_error";
            }
            this.mainGUI.addCheckComponentPanel(this.getComponenetPanel(this.lang.getTex("scheduled_task_cli"), schtasksStatus, this.lang.getTex(schtasksStatusText)));
            this.mainGUI.addCheckComponentPanel(this.getComponenetPanel(this.lang.getTex("scheduled_updater_task"), schtasksUpdaterStatus, this.lang.getTex(schtasksUpdaterStatusText)));
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void setMacComponents() {
        try {
            String statusText;
            boolean status;
            String osxNotificationWrapper = Function.getOsxNotificationWrapperPath();
            if (Function.fileExists(osxNotificationWrapper)) {
                status = true;
                statusText = "notification_wrapper_ok";
            } else {
                status = false;
                statusText = "notification_wrapper_error";
            }
            this.mainGUI.addCheckComponentPanel(this.getComponenetPanel(this.lang.getTex("notification_wrapper"), status, this.lang.getTex(statusText)));
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected boolean getSchtasksStatus() {
        boolean status = false;
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"schtasks", "/?"});
            p.waitFor();
            if (p.exitValue() == 0) {
                status = true;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        return status;
    }

    protected boolean getSchtasksUpdaterStatus() {
        boolean status = false;
        try {
            String line;
            Process proc = Runtime.getRuntime().exec(new String[]{"schtasks", "/QUERY"});
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((line = stdInput.readLine()) != null) {
                if (!StringUtils.contains((CharSequence)line, "ESO-Hub-Client-Updater")) continue;
                status = true;
                break;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        return status;
    }
}

