/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client.threads;

import com.hub.eso.client.threads.Threads;
import com.hub.eso.client.utils.ExceptionHandler;
import com.hub.eso.client.utils.Function;
import java.io.File;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.FileFileFilter;

public class LogCleaner
implements Runnable {
    public static final int NUM_KEEP_FILES = 20;
    protected final String logFolderPath = Function.getLogFolderForOS();

    @Override
    public void run() {
        try {
            if (!Threads.getInstance().addThreadToStack(Thread.currentThread().getName(), Thread.currentThread())) {
                return;
            }
            if (Function.dirExists(this.logFolderPath)) {
                File[] files = this.getLogFiles();
                this.removeOldLogFiles(files);
            }
            Threads.getInstance().removeThreadFromStack(Thread.currentThread().getName());
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected File[] getLogFiles() {
        File currentDirectory = new File(this.logFolderPath);
        LastModifiedFileComparator comparator = new LastModifiedFileComparator();
        return comparator.sort(currentDirectory.listFiles(FileFileFilter.INSTANCE));
    }

    protected void removeOldLogFiles(File[] files) {
        int numDeleteFiles = files.length - 20;
        if (numDeleteFiles > 0) {
            for (int i = 0; i < numDeleteFiles; ++i) {
                files[i].delete();
            }
        }
    }
}

