/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client.utils;

import com.hub.eso.client.ClientGUI;
import com.hub.eso.client.utils.ExceptionHandler;
import com.hub.eso.client.vars.Colors;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NavigationController {
    protected final HashMap<String, HashMap<String, Object>> elementList = new HashMap();
    protected final ClientGUI mainGUI;
    protected JPanel activeElement;

    public NavigationController(ClientGUI mainGUI) {
        this.mainGUI = mainGUI;
    }

    public void addElement(JPanel panel, JLabel label, String iconOn, String iconOff) {
        try {
            if (this.activeElement == null) {
                this.activeElement = panel;
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("panel", panel);
            data.put("label", label);
            data.put("icon_on", iconOn);
            data.put("icon_off", iconOff);
            this.elementList.put(label.getName(), data);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public void setActiveElement(String key) {
        try {
            for (Map.Entry<String, HashMap<String, Object>> pair : this.elementList.entrySet()) {
                HashMap<String, Object> data = pair.getValue();
                JPanel panel = (JPanel)data.get("panel");
                JLabel label = (JLabel)data.get("label");
                if (pair.getKey().equals(key)) {
                    this.activeElement = panel;
                    panel.setVisible(true);
                    label.setForeground(Colors.ACTIVE_TEXT_COLOR);
                    label.setIcon(new ImageIcon(this.getClass().getResource("/" + String.valueOf(data.get("icon_on")) + ".png")));
                    continue;
                }
                panel.setVisible(false);
                label.setForeground(Colors.INACTIVE_TEXT_COLOR);
                label.setIcon(new ImageIcon(this.getClass().getResource("/" + String.valueOf(data.get("icon_off")) + ".png")));
            }
            this.mainGUI.hideCheckComponentsPanel();
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public JPanel getActiveElement() {
        return this.activeElement;
    }
}

