/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client;

import com.hub.eso.client.ClientGUI;
import com.hub.eso.client.language.LanguageHandler;
import com.hub.eso.client.threads.UserLogin;
import com.hub.eso.client.threads.UserLogout;
import com.hub.eso.client.utils.ExceptionHandler;
import com.hub.eso.client.utils.Settings;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class User {
    protected final ClientGUI mainGUI;
    protected final LanguageHandler lang;
    protected final JTextField usernameTextField;
    protected final JPasswordField passwordTextField;
    protected String userName = "";
    protected String userSecureID = "";
    protected String userToken = "";

    public User(ClientGUI mainGUI) {
        this.mainGUI = mainGUI;
        this.lang = this.mainGUI.getLanguageHandler();
        this.usernameTextField = this.mainGUI.getUserNameField();
        this.passwordTextField = this.mainGUI.getUserPasswordField();
        try {
            String userToken = this.mainGUI.getSettings().getValue("UserAuthToken");
            if (!userToken.isEmpty()) {
                this.userToken = userToken;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public void login() {
        if (this.getUserNameValue().isEmpty()) {
            this.mainGUI.setWorkingPanel(true, this.lang.getTex("login_error_title"), this.lang.getTex("login_error_no_username"), "times.png", true, null);
        } else if (this.getPasswordValue().isEmpty()) {
            this.mainGUI.setWorkingPanel(true, this.lang.getTex("login_error_title"), this.lang.getTex("login_error_no_password"), "times.png", true, null);
        } else {
            this.mainGUI.setWorkingPanel(true, this.lang.getTex("notify_login"), this.lang.getTex("notify_login_text"), "loading.gif", false, null);
            Thread addonWorkerThread = new Thread(new UserLogin());
            addonWorkerThread.setName("user_login");
            addonWorkerThread.setDaemon(true);
            addonWorkerThread.start();
        }
    }

    public void logout() {
        try {
            Thread logoutThread = new Thread(new UserLogout(this.getUserToken()));
            logoutThread.setName("logout_thread");
            logoutThread.setDaemon(true);
            logoutThread.start();
            this.setUserName("");
            this.setUserSecureID("");
            this.setUserToken("");
            this.mainGUI.getUserNameField().setText("");
            this.mainGUI.getUserPasswordField().setText("");
            this.mainGUI.showAccountPanel(UserLoginState.LOGGED_OUT);
            this.mainGUI.setLoginNoticePanel(true);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public String getUserNameValue() {
        return this.usernameTextField.getText();
    }

    public String getPasswordValue() {
        return String.copyValueOf(this.passwordTextField.getPassword());
    }

    public synchronized void setUserName(String name) {
        this.userName = name;
    }

    public synchronized String getUserName() {
        return this.userName;
    }

    public synchronized void setUserSecureID(String id) {
        this.userSecureID = id;
    }

    public synchronized String getUserSecureID() {
        return this.userSecureID;
    }

    public synchronized void setUserToken(String token) {
        try {
            Settings settings = this.mainGUI.getSettings();
            settings.setValue("UserAuthToken", token);
            this.userToken = token;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public synchronized String getUserToken() {
        return this.userToken;
    }

    public static enum UserLoginState {
        LOGGED_IN,
        LOGGED_OUT;

    }
}

