/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client.gui;

import com.hub.eso.client.components.JGradientButton;
import com.hub.eso.client.components.JTooltipCheckBox;
import com.hub.eso.client.components.JTooltipLabel;
import com.hub.eso.client.gui.ResourceHelper;
import com.hub.eso.client.vars.Colors;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class GUIHelper {
    protected static final int DEFAULT_LABEL_TEXT_SIZE = 14;
    protected static final int DEFAULT_LABEL_FONT_WEIGHT = 0;
    protected static final Color DEFAULT_LABEL_FOREGROUND = Colors.ACTIVE_TEXT_COLOR;
    protected static final int DEFAULT_GRADIENT_BUTTON_TEXT_SIZE = 13;
    protected static final int DEFAULT_GRADIENT_BUTTON_FONT_WEIGHT = 1;
    protected static final Color DEFAULT_GRADIENT_BUTTON_FOREGROUND = Colors.ACTIVE_TEXT_COLOR;
    protected static final Color DEFAULT_GRADIENT_BUTTON_START_COLOR = Colors.BUTTON_GREEN_COLOR_START;
    protected static final Color DEFAULT_GRADIENT_BUTTON_END_COLOR = Colors.BUTTON_GREEN_COLOR_END;
    protected static final Color DEFAULT_GRADIENT_BUTTON_HOVER_START_COLOR = Colors.BUTTON_GREEN_COLOR_HOVER_START;
    protected static final Color DEFAULT_GRADIENT_BUTTON_HOVER_END_COLOR = Colors.BUTTON_GREEN_COLOR_HOVER_END;
    protected static final int DEFAULT_TEXT_FIELD_TEXT_SIZE = 14;
    protected static final int DEFAULT_TEXT_FIELD_FONT_WEIGHT = 0;
    protected static final Color DEFAULT_TEXT_FIELD_FOREGROUND = Colors.ACTIVE_TEXT_COLOR;
    protected static final Color DEFAULT_TEXT_FIELD_BACKGROUND = Colors.INPUT_BACKGROUND_COLOR;
    protected static final int DEFAULT_CHECK_BOX_TEXT_SIZE = 13;
    protected static final int DEFAULT_CHECK_BOX_FONT_WEIGHT = 0;
    protected static final Color DEFAULT_CHECK_BOX_FOREGROUND = Colors.TEXT_COLOR_REGULAR;

    public static JLabel getLabel() {
        return GUIHelper.getLabel("", 0, 14, DEFAULT_LABEL_FOREGROUND);
    }

    public static JLabel getLabel(String text) {
        return GUIHelper.getLabel(text, 0, 14, DEFAULT_LABEL_FOREGROUND);
    }

    public static JLabel getLabel(String text, int fontWeight) {
        return GUIHelper.getLabel(text, fontWeight, 14, DEFAULT_LABEL_FOREGROUND);
    }

    public static JLabel getLabel(String text, int fontWeight, int fontSize) {
        return GUIHelper.getLabel(text, fontWeight, fontSize, DEFAULT_LABEL_FOREGROUND);
    }

    public static JLabel getLabel(String text, Color color) {
        return GUIHelper.getLabel(text, 14, 14, color);
    }

    public static JLabel getLabel(String text, int fontWeight, int fontSize, Color color) {
        JLabel label = new JLabel();
        label.setDoubleBuffered(false);
        label.setFont(new Font("Roboto", fontWeight, fontSize));
        label.setForeground(color);
        label.setText(text);
        return label;
    }

    public static JTooltipLabel getTooltipLabel(String text, int fontWeight, int fontSize, Color color) {
        JTooltipLabel label = new JTooltipLabel();
        label.setDoubleBuffered(false);
        label.setFont(new Font("Roboto", fontWeight, fontSize));
        label.setForeground(color);
        label.setText(text);
        return label;
    }

    public static JLabel getTitleLabel(String text, int x, int y, int width, int height) {
        JLabel label = GUIHelper.getLabel(text, 1, 14, DEFAULT_LABEL_FOREGROUND);
        label.setBounds(x, y, width, height);
        label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Colors.BORDER_BRIGHT_COLOR));
        return label;
    }

    public static JPanel getPanel(Color background, LayoutManager layout, int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        Dimension size = new Dimension(width, height);
        panel.setDoubleBuffered(false);
        panel.setBackground(background);
        panel.setLayout(layout);
        panel.setPreferredSize(size);
        panel.setMaximumSize(size);
        panel.setMinimumSize(size);
        panel.setBounds(x, y, width, height);
        return panel;
    }

    public static JPanel getScrollPanel(Color background, int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setDoubleBuffered(false);
        panel.setBackground(background);
        panel.setBounds(x, y, width, height);
        return panel;
    }

    public static JGradientButton getGradientButton(String text) {
        return GUIHelper.getGradientButton(text, 1, 13, DEFAULT_GRADIENT_BUTTON_FOREGROUND, DEFAULT_GRADIENT_BUTTON_START_COLOR, DEFAULT_GRADIENT_BUTTON_END_COLOR, DEFAULT_GRADIENT_BUTTON_HOVER_START_COLOR, DEFAULT_GRADIENT_BUTTON_HOVER_END_COLOR);
    }

    public static JGradientButton getGradientButton(String text, int fontWeight, int fontSize, Color color, Color startColor, Color endColor, Color startHoverColor, Color endHoverColor) {
        JGradientButton button = new JGradientButton(startColor, endColor, startHoverColor, endHoverColor);
        button.setFont(new Font("Roboto", fontWeight, fontSize));
        button.setForeground(color);
        button.setText(text);
        button.setDoubleBuffered(false);
        button.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Colors.BORDER_COLOR), new EmptyBorder(0, 6, 0, 0)));
        button.setCursor(new Cursor(12));
        return button;
    }

    public static JTextField getTextField() {
        return GUIHelper.getTextField(0, 14, DEFAULT_TEXT_FIELD_FOREGROUND, DEFAULT_TEXT_FIELD_BACKGROUND);
    }

    public static JTextField getTextField(int fontWeight, int fontSize, Color color, Color backColor) {
        JTextField textField = new JTextField();
        textField.setDoubleBuffered(false);
        textField.setFont(new Font("Roboto", fontWeight, fontSize));
        textField.setForeground(color);
        textField.setBackground(backColor);
        textField.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Colors.BORDER_INPUT_COLOR), new EmptyBorder(2, 4, 2, 4)));
        textField.setCaretColor(Colors.ACTIVE_TEXT_COLOR);
        return textField;
    }

    public static JCheckBox getCheckBox(String text) {
        JCheckBox checkBox = new JCheckBox();
        checkBox.setDoubleBuffered(false);
        checkBox.setFont(new Font("Roboto", 0, 13));
        checkBox.setForeground(DEFAULT_CHECK_BOX_FOREGROUND);
        checkBox.setText(text);
        checkBox.setOpaque(false);
        checkBox.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Colors.BORDER_COLOR));
        checkBox.setCursor(new Cursor(12));
        checkBox.setFocusPainted(false);
        checkBox.setIconTextGap(2);
        ResourceHelper.setComponentIcon(checkBox, "square-o.png", 20, 20);
        ResourceHelper.setComponentIconSelected(checkBox, "check-square-o.png", 20, 20);
        return checkBox;
    }

    public static JTooltipCheckBox getTooltipCheckBox(String text) {
        JTooltipCheckBox checkBox = new JTooltipCheckBox();
        checkBox.setDoubleBuffered(false);
        checkBox.setFont(new Font("Roboto", 0, 13));
        checkBox.setForeground(DEFAULT_CHECK_BOX_FOREGROUND);
        checkBox.setText(text);
        checkBox.setOpaque(false);
        checkBox.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Colors.BORDER_COLOR));
        checkBox.setCursor(new Cursor(12));
        checkBox.setFocusPainted(false);
        checkBox.setIconTextGap(2);
        ResourceHelper.setComponentIcon(checkBox, "square-o.png", 20, 20);
        ResourceHelper.setComponentIconSelected(checkBox, "check-square-o.png", 20, 20);
        return checkBox;
    }
}

