/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client.gui;

import com.hub.eso.client.ClientGUI;
import com.hub.eso.client.components.JGradientButton;
import com.hub.eso.client.utils.ExceptionHandler;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class ResourceHelper {
    public static void setComponentIcon(JLabel comp, String path, int width, int height) {
        try {
            ResourceHelper.setComponentImageIcon(comp, comp.getClass().getSimpleName(), path, width, height, false);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public static void setComponentIcon(JGradientButton comp, String path, int width, int height) {
        try {
            ResourceHelper.setComponentImageIcon(comp, comp.getClass().getSimpleName(), path, width, height, false);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public static void setComponentIcon(JCheckBox comp, String path, int width, int height) {
        try {
            ResourceHelper.setComponentImageIcon(comp, comp.getClass().getSimpleName(), path, width, height, false);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public static void setComponentIconSelected(JCheckBox comp, String path, int width, int height) {
        try {
            ResourceHelper.setComponentImageIcon(comp, comp.getClass().getSimpleName(), path, width, height, true);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public static void registerFont() {
        try {
            System.setProperty("awt.useSystemAAFontSettings", "gasp");
            System.setProperty("swing.aatext", "true");
            URL url = ClientGUI.class.getResource("/fonts/Roboto-Regular.ttf");
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(Font.createFont(0, url.openStream()));
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected static void setComponentImageIcon(Component comp, String compClassName, String path, int width, int height, boolean iconSelected) {
        try {
            Image img = ResourceHelper.getScaledImageFromResources("/" + path, width, height);
            if (img != null) {
                switch (compClassName) {
                    case "JLabel": 
                    case "JTooltipLabel": {
                        ((JLabel)comp).setIcon(new ImageIcon(img));
                        break;
                    }
                    case "JGradientButton": {
                        ((JGradientButton)comp).setIcon(new ImageIcon(img));
                        break;
                    }
                    case "JCheckBox": 
                    case "JTooltipCheckBox": {
                        if (iconSelected) {
                            ((JCheckBox)comp).setSelectedIcon(new ImageIcon(img));
                            break;
                        }
                        ((JCheckBox)comp).setIcon(new ImageIcon(img));
                    }
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected static Image getScaledImageFromResources(String path, int width, int height) {
        try {
            BufferedImage image = ImageIO.read(ClientGUI.class.getResourceAsStream(path));
            if (image != null) {
                if (image.getWidth() != width && image.getHeight() != height) {
                    return image.getScaledInstance(width, height, 4);
                }
                return Toolkit.getDefaultToolkit().getImage(ClientGUI.class.getResource(path));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        return null;
    }
}

