/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client.threads;

import com.hub.eso.client.threads.AddOnPanelBuilder;
import com.hub.eso.client.threads.LogCleaner;
import com.hub.eso.client.threads.Threads;
import com.hub.eso.client.threads.UpdateCheck;
import com.hub.eso.client.utils.ExceptionHandler;

class Cronjob
implements Runnable {
    protected long addOnPanelBuilderLastRun;
    protected long updateCheckLastRun;
    protected long logCleanerLastRun;

    Cronjob() {
    }

    @Override
    public void run() {
        try {
            if (!Threads.getInstance().addThreadToStack(Thread.currentThread().getName(), Thread.currentThread())) {
                return;
            }
            this.addOnPanelBuilderLastRun = 0L;
            this.updateCheckLastRun = 0L;
            this.logCleanerLastRun = 0L;
            while (true) {
                try {
                    this.cronAddOnWorkerPanel();
                    this.cronUpdateCheck();
                    this.logCleaner();
                }
                catch (Exception e) {
                    ExceptionHandler.handle(e);
                }
                Thread.sleep(30000L);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return;
        }
    }

    protected void cronAddOnWorkerPanel() {
        try {
            long durationMs = System.currentTimeMillis() - this.addOnPanelBuilderLastRun;
            if (durationMs > 180000L) {
                Thread thread = new Thread(new AddOnPanelBuilder());
                thread.setName("addon_panel_builder_thread");
                thread.setDaemon(true);
                thread.start();
                this.addOnPanelBuilderLastRun = System.currentTimeMillis();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void cronUpdateCheck() {
        try {
            long durationMs = System.currentTimeMillis() - this.updateCheckLastRun;
            if (durationMs > 600000L) {
                Thread thread = new Thread(new UpdateCheck(false));
                thread.setName("update_check_thread");
                thread.setDaemon(true);
                thread.start();
                this.updateCheckLastRun = System.currentTimeMillis();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void logCleaner() {
        try {
            long durationMs = System.currentTimeMillis() - this.logCleanerLastRun;
            if (durationMs > 600000L) {
                Thread thread = new Thread(new LogCleaner());
                thread.setName("log_cleaner_thread");
                thread.setDaemon(true);
                thread.start();
                this.logCleanerLastRun = System.currentTimeMillis();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }
}

