/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client.threads;

import com.hub.eso.client.ClientGUI;
import com.hub.eso.client.components.JAddOnPanel;
import com.hub.eso.client.language.LanguageHandler;
import com.hub.eso.client.threads.Threads;
import com.hub.eso.client.utils.AddOnPanelHelper;
import com.hub.eso.client.utils.ExceptionHandler;
import com.hub.eso.client.utils.Function;
import com.hub.eso.client.utils.Settings;
import com.hub.eso.client.web.WebClass;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class TransferWorker
implements Runnable {
    public static final int CREATE_TMP_FILE_MAX_ATTEMPTS = 6;
    public static final int CREATE_TMP_FILE_THREAD_WAIT = 1000;
    protected final ClientGUI mainGUI = ClientGUI.getInstance();
    protected final LanguageHandler lang = this.mainGUI.getLanguageHandler();
    protected final Settings settings = this.mainGUI.getSettings();
    protected final File svFile;
    protected final String endpoint;
    protected final String folderName;
    protected final AddOnPanelHelper addOnPanelHelper;
    protected File tempDir;

    public TransferWorker(File svFile, String endpoint, String folderName) {
        this.svFile = svFile;
        this.endpoint = endpoint;
        this.folderName = folderName;
        this.addOnPanelHelper = new AddOnPanelHelper();
        this.tempDir = null;
    }

    @Override
    public void run() {
        try {
            if (!Threads.getInstance().addThreadToStack(Thread.currentThread().getName(), Thread.currentThread())) {
                return;
            }
            this.handleLUAFile(1);
            Threads.getInstance().removeThreadFromStack(Thread.currentThread().getName());
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected File getTempLuaFile(File luaFile) {
        try {
            String timeStamp = new SimpleDateFormat("yyyyMMddHHmmsss").format(new Date());
            Path tempDirWithPrefix = Files.createTempDirectory("eso_hub_client_lua_", new FileAttribute[0]);
            this.tempDir = new File(tempDirWithPrefix.toAbsolutePath().toString());
            String tempDirPath = String.valueOf(this.tempDir) + File.separator + timeStamp;
            String svFileTmpPath = tempDirPath + File.separator + this.svFile.getName();
            File tempDirObj = new File(tempDirPath);
            if (!tempDirObj.exists()) {
                tempDirObj.mkdirs();
            }
            File luaFileObj = new File(svFileTmpPath);
            Files.copy(luaFile.toPath(), luaFileObj.toPath(), new CopyOption[0]);
            return luaFileObj;
        }
        catch (FileSystemException timeStamp) {
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected File createTarFile(File file) {
        try {
            String timeStamp = new SimpleDateFormat("yyyyMMddHHmmsss").format(new Date());
            File tarFile = new File(this.tempDir.toString() + File.separator + timeStamp + ".tar");
            tarFile.createNewFile();
            try (TarArchiveOutputStream out = (TarArchiveOutputStream)new ArchiveStreamFactory().createArchiveOutputStream("tar", new FileOutputStream(tarFile));){
                File file2;
                out.setLongFileMode(2);
                TarArchiveEntry entry = new TarArchiveEntry(file, file.getName());
                FileInputStream in = new FileInputStream(file);
                try {
                    out.putArchiveEntry(entry);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    out.closeArchiveEntry();
                    file2 = tarFile;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                ((InputStream)in).close();
                return file2;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected File createGZipFile(File tarFile) {
        try {
            String settingsCompressionLevel = this.settings.getValue("CompressionLevel");
            if (settingsCompressionLevel.isEmpty()) {
                settingsCompressionLevel = "9";
            }
            int compressionLevel = Integer.parseInt(settingsCompressionLevel);
            File gzipFile = new File(tarFile.toPath().getParent().toFile(), tarFile.getName() + ".gz");
            byte[] buffer = new byte[1024];
            GzipParameters parameters = new GzipParameters();
            parameters.setCompressionLevel(compressionLevel);
            try (FileInputStream in = new FileInputStream(tarFile);){
                File file;
                try (GzipCompressorOutputStream gzipOut = new GzipCompressorOutputStream(new FileOutputStream(gzipFile), parameters);){
                    int len;
                    while ((len = in.read(buffer)) > 0) {
                        gzipOut.write(buffer, 0, len);
                    }
                    file = gzipFile;
                }
                return file;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return null;
        }
    }

    protected void handleLUAFile(int attempts) {
        try {
            if (this.svFile.exists()) {
                JAddOnPanel addOnPanel = this.addOnPanelHelper.getJAddonPanel(this.folderName);
                if (!addOnPanel.getAddOnEnabled()) {
                    return;
                }
                if (attempts > 6) {
                    addOnPanel.setStatus(1);
                    this.cleanupTempDir();
                    this.mainGUI.showNotification(this.lang.getTex("global_tooltip_transfer_title"), this.lang.getTex("global_tooltip_transfer_error") + " (E_5000)");
                    return;
                }
                addOnPanel.setStatus(2);
                File svRenamedFile = this.getTempLuaFile(this.svFile);
                if (svRenamedFile != null) {
                    File tarFile = this.createTarFile(svRenamedFile);
                    if (tarFile != null) {
                        File gzipFile = this.createGZipFile(tarFile);
                        if (gzipFile != null) {
                            WebClass web = new WebClass(this.lang);
                            web.addTransferStateListener(state -> {
                                if (state == 1) {
                                    addOnPanel.setStatus(3);
                                } else {
                                    addOnPanel.setStatus(1);
                                }
                            });
                            web.addUploadListener((bytesSent, bytesTotal, percentCompleted) -> {
                                String langEntry = StringUtils.replace(this.lang.getTex("information_upload_progress_text"), "%bytes_read%", Function.bytesToHuman(bytesSent));
                                langEntry = StringUtils.replace(langEntry, "%bytes_total%", Function.bytesToHuman(bytesTotal));
                                langEntry = StringUtils.replace(langEntry, "%percent%", Integer.toString(percentCompleted));
                                addOnPanel.setStatus(3);
                                addOnPanel.setStatusText(langEntry);
                                addOnPanel.setProgressBar(percentCompleted, true);
                                if (percentCompleted == 100) {
                                    addOnPanel.setStatus(4);
                                }
                            });
                            boolean uploadResult = web.uploadLUAFile(this.endpoint, gzipFile.toPath().toString(), this.mainGUI.getUser());
                            if (uploadResult) {
                                long transferDate = System.currentTimeMillis();
                                long transferredFiles = Long.parseLong(this.settings.getValue("TransferredFiles"));
                                long transferredBytes = Long.parseLong(this.settings.getValue("TransferredBytes"));
                                this.mainGUI.setTransferredFiles(Function.numberFormat(++transferredFiles, 0));
                                this.mainGUI.setTransferredBytes(Function.bytesToHuman(transferredBytes += gzipFile.length()));
                                this.settings.setValue("TransferredFiles", Long.toString(transferredFiles));
                                this.settings.setValue("TransferredBytes", Long.toString(transferredBytes));
                                this.settings.setValue("LastSentAddOn" + addOnPanel.getAddonFolderName(), Long.toString(transferDate));
                                addOnPanel.setLastTransfer();
                                if (!addOnPanel.getDisableable()) {
                                    this.mainGUI.showNotification(this.lang.getTex("global_tooltip_transfer_title"), this.lang.getTex("global_tooltip_transfer"));
                                }
                            } else {
                                addOnPanel.setStatus(7);
                                this.mainGUI.showNotification(this.lang.getTex("global_tooltip_transfer_title"), this.lang.getTex("global_tooltip_transfer_error"));
                            }
                            this.cleanupTempDir();
                        } else {
                            addOnPanel.setStatus(1);
                            this.cleanupTempDir();
                            this.mainGUI.showNotification(this.lang.getTex("global_tooltip_transfer_title"), this.lang.getTex("global_tooltip_transfer_error") + " (E2000)");
                        }
                    } else {
                        addOnPanel.setStatus(1);
                        this.cleanupTempDir();
                        this.mainGUI.showNotification(this.lang.getTex("global_tooltip_transfer_title"), this.lang.getTex("global_tooltip_transfer_error") + " (E1000)");
                    }
                    if (svRenamedFile.exists()) {
                        svRenamedFile.delete();
                    }
                } else {
                    addOnPanel.setStatus(1);
                    this.cleanupTempDir();
                    Thread.sleep(1000L);
                    this.handleLUAFile(++attempts);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void cleanupTempDir() {
        try {
            if (this.tempDir != null) {
                FileUtils.deleteDirectory(this.tempDir);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }
}

