/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client.threads;

import com.hub.eso.client.ClientGUI;
import com.hub.eso.client.exceptions.UpdateException;
import com.hub.eso.client.language.LanguageHandler;
import com.hub.eso.client.threads.Threads;
import com.hub.eso.client.utils.ExceptionHandler;
import com.hub.eso.client.utils.Function;
import com.hub.eso.client.web.WebClass;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.Callable;
import net.lingala.zip4j.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class UpdateCheck
implements Runnable {
    protected final ClientGUI mainGUI = ClientGUI.getInstance();
    protected final WebClass web = this.mainGUI.getWebClass();
    protected final LanguageHandler lang = this.mainGUI.getLanguageHandler();
    protected final boolean userInteraction;
    protected final String updateFilesFolderPath;
    protected final String updateMetaFilePath;

    public UpdateCheck(boolean userInteraction) {
        this.userInteraction = userInteraction;
        this.updateFilesFolderPath = UpdateCheck.getFilesFolderPath();
        this.updateMetaFilePath = UpdateCheck.getUpdateMetaFilePath();
    }

    @Override
    public void run() {
        try {
            if (!Threads.getInstance().addThreadToStack(Thread.currentThread().getName(), Thread.currentThread())) {
                return;
            }
            if (this.userInteraction) {
                this.mainGUI.setWorkingPanel(true, this.lang.getTex("update_check_title"), this.lang.getTex("update_check_text"), "loading.gif", false, null);
            }
            UpdateCheck.cleanupUpdateDirectory();
            HashMap<String, Object> clientVersionInfo = this.web.getClientVersionInfo();
            assert (clientVersionInfo != null);
            if (clientVersionInfo.containsKey("version_int")) {
                int serverVersion = (Integer)clientVersionInfo.get("version_int");
                if (serverVersion > 1009) {
                    boolean status = this.downloadUpdateFiles((JSONObject)clientVersionInfo.get("data"));
                    if (status) {
                        this.createUpdateMetaFile(Integer.parseInt(clientVersionInfo.get("version_int").toString()));
                        this.mainGUI.showUpdateBanner(clientVersionInfo.get("version_str").toString());
                        String tooltipUpdateText = StringUtils.replace(this.lang.getTex("global_tooltip_client_update_text"), "%version%", clientVersionInfo.get("version_str").toString());
                        this.mainGUI.showNotification(this.lang.getTex("global_tooltip_client_update_title"), tooltipUpdateText);
                        if (this.userInteraction) {
                            String panelText = StringUtils.replace(this.lang.getTex("update_check_new_update_text"), "%current_version%", "1.0.9");
                            panelText = StringUtils.replace(panelText, "%new_version%", clientVersionInfo.get("version_str").toString());
                            this.mainGUI.setWorkingPanel(true, this.lang.getTex("update_check_new_update_title"), panelText, "download.png", true, UpdateCheck.workingPanelInstallClick());
                        }
                    } else {
                        UpdateCheck.cleanupUpdateDirectory();
                        ExceptionHandler.handle(new UpdateException("Update download canceled because of download data errors."));
                    }
                } else if (this.userInteraction) {
                    this.mainGUI.setWorkingPanel(true, this.lang.getTex("update_check_no_update_title"), this.lang.getTex("update_check_no_update_text"), "check.png", true, null);
                }
            }
            Threads.getInstance().removeThreadFromStack(Thread.currentThread().getName());
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public static synchronized Callable<?> workingPanelInstallClick() {
        return () -> {
            UpdateCheck.runUpdate();
            return null;
        };
    }

    public static synchronized String getFilesFolderPath() {
        return Function.getUpdateFolderForOS() + File.separator + "files";
    }

    public static synchronized String getUpdateMetaFilePath() {
        return Function.getUpdateFolderForOS() + File.separator + "update.json";
    }

    public static synchronized boolean getPendingUpdateStatus() {
        boolean status = false;
        try {
            JSONObject meta;
            String updateMetaFile = UpdateCheck.getUpdateMetaFilePath();
            if (Function.fileExists(updateMetaFile) && (meta = UpdateCheck.getUpdateMetaInfo()) != null && meta.getInt("to_version_int") > 1009) {
                status = true;
            }
            if (!status) {
                UpdateCheck.cleanupUpdateDirectory();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        return status;
    }

    public static synchronized void runUpdate() {
        try {
            String os = Function.getShortOSName();
            if (os.equals("windows")) {
                UpdateCheck.runUpdaterWindows();
            } else if (os.equals("mac")) {
                UpdateCheck.runUpdaterOSX();
            } else {
                UpdateCheck.runUpdaterJar();
            }
            System.exit(0);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public static synchronized void cleanupUpdateDirectory() {
        try {
            String updateFolderPath = Function.getUpdateFolderForOS();
            String updateFilesFolderPath = UpdateCheck.getFilesFolderPath();
            try {
                FileUtils.deleteDirectory(new File(updateFolderPath));
            }
            catch (Exception exception) {
                // empty catch block
            }
            File filesDir = new File(updateFilesFolderPath);
            if (!filesDir.exists()) {
                filesDir.mkdirs();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public static synchronized JSONObject getUpdateMetaInfo() {
        JSONObject meta = null;
        try {
            String updateMetaFile = UpdateCheck.getUpdateMetaFilePath();
            if (Function.fileExists(updateMetaFile)) {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(updateMetaFile));
                StringBuilder builder = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    builder.append(line);
                }
                br.close();
                meta = new JSONObject(builder.toString());
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        return meta;
    }

    protected static void runUpdaterWindows() {
        try {
            String installerPath = null;
            String filesDir = UpdateCheck.getFilesFolderPath();
            File filesFolder = new File(filesDir);
            for (File fileEntry : Objects.requireNonNull(filesFolder.listFiles())) {
                if (!fileEntry.isFile() || !FilenameUtils.getExtension(fileEntry.getName()).equals("exe")) continue;
                installerPath = filesDir + File.separator + fileEntry.getName();
                break;
            }
            if (installerPath != null) {
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                processBuilder.command("schtasks", "/RUN", "/TN", "\"ESO-Hub-Client-Updater\"");
                processBuilder.start();
                System.exit(0);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected static void runUpdaterOSX() {
        try {
            String appPath = Function.getMacOSAppPath();
            if (Function.getShortOSName().equals("mac") && System.getenv("DEV") != null) {
                appPath = "/Applications/ESO-Hub Client.app";
            }
            if (appPath != null) {
                String jarFile = appPath + File.separator + "Contents" + File.separator + "Java" + File.separator + "eso_hub_client.jar";
                Runtime.getRuntime().exec(new String[]{"java", "-jar", jarFile, "-updater", "--app-path=" + appPath});
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected static void runUpdaterJar() {
        try {
            String jarName = System.getProperty("java.class.path");
            String destPath = Function.getWorkingDirectory() + File.separator + jarName;
            Runtime.getRuntime().exec(new String[]{Function.getJreJavaBin(), "-jar", destPath, "-updater"});
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void createUpdateMetaFile(int versionInt) {
        try {
            JSONObject updateMeta = new JSONObject();
            updateMeta.put("to_version_int", versionInt);
            updateMeta.put("from_version_int", 1009);
            FileWriter file = new FileWriter(this.updateMetaFilePath);
            file.write(updateMeta.toString(2));
            file.flush();
            file.close();
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected boolean downloadUpdateFiles(JSONObject data) {
        boolean status = false;
        try {
            String osShortName = Function.getShortOSName();
            JSONObject fileObject = data.getJSONObject("files");
            JSONArray downloadFiles = fileObject.getJSONArray(osShortName);
            WebClass web = new WebClass(this.lang);
            int length = downloadFiles.length();
            for (int i = 0; i < length; ++i) {
                JSONObject fileObj = downloadFiles.getJSONObject(i);
                String fileUrl = fileObj.getString("file");
                String fileChecksum = fileObj.getString("checksum");
                String fileName = new File(fileUrl).getName();
                if (osShortName.equals("windows") && !fileName.endsWith(".exe")) {
                    fileName = "eso_hub_client_installer.exe";
                } else if (osShortName.equals("mac") && !fileName.endsWith(".zip")) {
                    fileName = "eso_hub_client.zip";
                } else if (osShortName.equals("linux") && !fileName.endsWith(".jar")) {
                    fileName = "eso_hub_client.jar";
                } else if (osShortName.equals("unknown") && !fileName.endsWith(".jar")) {
                    fileName = "eso_hub_client.jar";
                }
                String downloadFilePath = this.updateFilesFolderPath + File.separator + fileName;
                if (!web.downloadFileBinary(fileUrl, downloadFilePath).booleanValue()) continue;
                String localFileChecksum = Function.getFileChecksum(downloadFilePath, "SHA-256");
                if (!localFileChecksum.equals(fileChecksum)) {
                    status = false;
                    ExceptionHandler.handle(new UpdateException("Update file checksum mismatch:\nFile: " + fileUrl + "\nFilename: " + fileName + "\nSource Checksum: " + fileChecksum + "\nLocal Checksum: " + localFileChecksum + "\n"));
                    break;
                }
                if (FilenameUtils.getExtension(fileUrl).equals("zip")) {
                    ZipFile downloadZip = new ZipFile(downloadFilePath);
                    downloadZip.extractAll(this.updateFilesFolderPath);
                    downloadZip.close();
                    Function.rmFile(downloadFilePath);
                }
                status = true;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            UpdateCheck.cleanupUpdateDirectory();
        }
        return status;
    }
}

