/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client.web;

import com.hub.eso.client.User;
import com.hub.eso.client.events.DownloadProgressListener;
import com.hub.eso.client.events.TransferStateListener;
import com.hub.eso.client.events.UploadProgressListener;
import com.hub.eso.client.language.LanguageHandler;
import com.hub.eso.client.utils.ExceptionHandler;
import com.hub.eso.client.utils.Function;
import com.hub.eso.client.vars.Const;
import com.hub.eso.client.web.ApiResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class WebClass {
    public static final String CRLF = "\r\n";
    private final LanguageHandler lang;
    private String multipartBoundary;
    private final List<DownloadProgressListener> downloadProgressListeners;
    private final List<UploadProgressListener> uploadProgressListeners;
    private final List<TransferStateListener> transferStateListeners;

    public WebClass(LanguageHandler lang) {
        this.lang = lang;
        this.multipartBoundary = null;
        this.downloadProgressListeners = new ArrayList<DownloadProgressListener>();
        this.uploadProgressListeners = new ArrayList<UploadProgressListener>();
        this.transferStateListeners = new ArrayList<TransferStateListener>();
        try {
            this.acceptAllCertificates();
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public void addDownloadListener(DownloadProgressListener toAdd) {
        this.downloadProgressListeners.add(toAdd);
    }

    public void addUploadListener(UploadProgressListener toAdd) {
        this.uploadProgressListeners.add(toAdd);
    }

    public void addTransferStateListener(TransferStateListener toAdd) {
        this.transferStateListeners.add(toAdd);
    }

    public synchronized ApiResult apiCall(Call call, HashMap<String, String> paramList) {
        block7: {
            try {
                String line;
                String apiUrl = "https://data.eso-hub.com/v1/api/" + URLEncoder.encode(call.value, Const.API_CHARSET) + "/";
                URL url = new URI(apiUrl).toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                StringBuilder data = new StringBuilder("client_system=" + Function.getShortOSName() + "&client_version=1.0.9&client_version_int=1009&lang=" + this.lang.getLanguage().toString().toLowerCase());
                if (paramList != null && !paramList.isEmpty()) {
                    for (Map.Entry<String, String> pair : paramList.entrySet()) {
                        data.append("&").append(pair.getKey()).append("=").append(URLEncoder.encode(pair.getValue(), Const.API_CHARSET));
                    }
                }
                connection.setRequestMethod("POST");
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setUseCaches(false);
                connection.setRequestProperty("User-Agent", "ESOHubClient/1.0.9");
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("Content-Length", String.valueOf(data.length()));
                StringBuilder respStr = new StringBuilder();
                OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), Const.API_CHARSET);
                writer.write(data.toString());
                writer.flush();
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), Const.API_CHARSET));
                while ((line = reader.readLine()) != null) {
                    respStr.append(line);
                }
                reader.close();
                if (respStr.toString().isEmpty()) break block7;
                respStr = new StringBuilder("[" + String.valueOf(respStr) + "]");
                JSONArray json = new JSONArray(respStr.toString());
                JSONObject responseJson = json.getJSONObject(0);
                JSONObject resultJson = responseJson.getJSONObject("result");
                ApiResult result = new ApiResult();
                result.setStatus(responseJson.getString("status").equals("OK") ? ApiResult.ApiStatus.OK : ApiResult.ApiStatus.KO);
                result.setStatusText(resultJson.getString("statustext"));
                try {
                    result.setData(resultJson.getJSONObject("data"));
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                return result;
            }
            catch (Exception e) {
                ExceptionHandler.handle(e);
            }
        }
        return null;
    }

    public synchronized boolean uploadLUAFile(String endpoint, String localPath, User user) {
        try {
            String resp;
            int bytesRead;
            boolean sendTransferStateEvents;
            StringBuilder respStr = new StringBuilder();
            this.multipartBoundary = Long.toHexString(System.currentTimeMillis());
            File luaFile = new File(localPath);
            boolean sendUploadEvents = !this.uploadProgressListeners.isEmpty();
            boolean bl = sendTransferStateEvents = !this.transferStateListeners.isEmpty();
            if (sendTransferStateEvents) {
                for (TransferStateListener listener : this.transferStateListeners) {
                    listener.stateChanged(1);
                }
            }
            URL url = new URI("https://data.eso-hub.com" + endpoint + "?user_token=" + user.getUserToken()).toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setRequestProperty("Connection", "Keep-Alive");
            connection.setRequestProperty("Cache-Control", "no-cache");
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.multipartBoundary);
            connection.setRequestProperty("User-Agent", "ESOHubClient/1.0.9");
            OutputStream output = connection.getOutputStream();
            PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(output, Const.API_CHARSET), true);
            InputStream inputStream = Files.newInputStream(luaFile.toPath(), new OpenOption[0]);
            byte[] buffer = new byte[4098];
            long totalBytesRead = 0L;
            long fileSize = luaFile.length();
            String fileName = luaFile.getName();
            writer.append(CRLF);
            writer.append("--").append(this.multipartBoundary);
            writer.append(CRLF);
            writer.append("Content-Disposition: form-data; name=\"file\"; filename=\"").append(fileName).append("\"");
            writer.append(CRLF);
            writer.append("Content-Type: ").append(URLConnection.guessContentTypeFromName(fileName));
            writer.append(CRLF);
            writer.append("Content-Transfer-Encoding: binary");
            writer.append(CRLF);
            writer.append(CRLF);
            writer.flush();
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
                if (!sendUploadEvents) continue;
                for (UploadProgressListener uploadProgressListener : this.uploadProgressListeners) {
                    int percentCompleted = (int)((totalBytesRead += (long)bytesRead) * 100L / fileSize);
                    uploadProgressListener.uploadProgress(totalBytesRead, fileSize, percentCompleted);
                }
            }
            output.flush();
            inputStream.close();
            writer.append(CRLF);
            writer.flush();
            writer.append("--").append(this.multipartBoundary).append("--").append(CRLF);
            writer.flush();
            writer.close();
            if (connection.getResponseCode() == 200) {
                String string;
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                while ((string = reader.readLine()) != null) {
                    respStr.append(string);
                }
                reader.close();
            }
            connection.disconnect();
            if (sendTransferStateEvents) {
                for (TransferStateListener transferStateListener : this.transferStateListeners) {
                    transferStateListener.stateChanged(2);
                }
            }
            if ((resp = respStr.toString()).equals("1")) {
                return true;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        return false;
    }

    public synchronized Boolean downloadFileBinary(String downloadURL, String destFile) {
        try {
            int bytesRead;
            URL url = new URI(downloadURL).toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoInput(true);
            connection.setDoOutput(false);
            connection.setUseCaches(false);
            connection.setRequestProperty("User-Agent", "ESOHubClient/1.0.9");
            byte[] buffer = new byte[4096];
            int contentLength = connection.getContentLength();
            long totalBytesRead = 0L;
            boolean sendDownloadEvents = !this.downloadProgressListeners.isEmpty();
            InputStream input = connection.getInputStream();
            FileOutputStream output = new FileOutputStream(destFile);
            while ((bytesRead = input.read(buffer)) != -1) {
                ((OutputStream)output).write(buffer, 0, bytesRead);
                if (!sendDownloadEvents) continue;
                for (DownloadProgressListener listener : this.downloadProgressListeners) {
                    int percentCompleted = (int)((totalBytesRead += (long)bytesRead) * 100L / (long)contentLength);
                    listener.downloadProgress(totalBytesRead, contentLength, percentCompleted);
                }
            }
            ((OutputStream)output).close();
            return true;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return false;
        }
    }

    public synchronized boolean internetConnectionStatus() {
        try {
            URL url = new URI("https://data.eso-hub.com/online.check").toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoInput(true);
            connection.setDoOutput(false);
            connection.setUseCaches(false);
            connection.setRequestProperty("User-Agent", "ESOHubClient/1.0.9");
            connection.getInputStream();
            return true;
        }
        catch (IOException url) {
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        return false;
    }

    public synchronized HashMap<String, Object> getClientVersionInfo() {
        try {
            JSONObject data;
            HashMap<String, Object> result = new HashMap<String, Object>();
            ApiResult resp = this.apiCall(Call.GetClientVersion, null);
            if (resp != null && (data = resp.getData()) != null) {
                result.put("version_str", data.getJSONObject("main").getJSONObject("version").getString("string"));
                result.put("version_int", data.getJSONObject("main").getJSONObject("version").getInt("integer"));
                result.put("data", data.getJSONObject("main"));
            }
            return result;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return null;
        }
    }

    public synchronized JSONObject getAddOnChangelog(LanguageHandler.Language lang) {
        try {
            JSONObject data;
            JSONObject result = null;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("changelog_lang", lang.toString());
            ApiResult resp = this.apiCall(Call.GetAddOnChangelog, params);
            if (resp != null && (data = resp.getData()) != null) {
                result = data;
            }
            return result;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return null;
        }
    }

    public synchronized JSONObject getClientChangelog(LanguageHandler.Language lang) {
        try {
            JSONObject data;
            JSONObject result = null;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("changelog_lang", lang.toString());
            ApiResult resp = this.apiCall(Call.GetClientChangelog, params);
            if (resp != null && (data = resp.getData()) != null) {
                result = data;
            }
            return result;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return null;
        }
    }

    private void acceptAllCertificates() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(this){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("TLSv1.2");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public static enum Call {
        Login("login"),
        LoginToken("login-token"),
        Logout("logout"),
        GetClientVersion("get-client-version"),
        GetAddOnVersions("get-addon-versions"),
        GetAddOnChangelog("get-addon-changelog"),
        GetClientChangelog("get-client-changelog"),
        SetAddOnVersions("set-addon-versions");

        private final String value;

        private Call(String value) {
            this.value = value;
        }
    }
}

