/*
 * Decompiled with CFR 0.152.
 */
package com.hub.eso.client.wizard;

import com.hub.eso.client.ClientGUI;
import com.hub.eso.client.components.JGradientButton;
import com.hub.eso.client.gui.GUIHelper;
import com.hub.eso.client.gui.ResourceHelper;
import com.hub.eso.client.language.LanguageHandler;
import com.hub.eso.client.utils.ExceptionHandler;
import com.hub.eso.client.utils.Function;
import com.hub.eso.client.utils.Settings;
import com.hub.eso.client.vars.Colors;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class Wizard {
    protected final Wizard self = this;
    protected final ClientGUI mainGUI;
    protected final Settings settings;
    protected final LanguageHandler lang;
    protected JPanel wizardPanel1;
    protected JPanel wizardPanel2;
    protected JLabel wizardPanel1TitleLabel;
    protected JLabel wizardPanel1TextLabel;
    protected JLabel wizardPanel2TitleLabel;
    protected JLabel wizardPanel2TextLabel;
    protected JLabel wizardPanel2ErrorLabel;
    protected JGradientButton wizardPanel1NextButton;
    protected JGradientButton wizardPanel2FinishButton;
    protected JGradientButton wizardPanel2BackButton;
    protected JLabel wizardPanel2ESOTitleLabel;
    protected JLabel wizardPanel2ESODataPathLabel;
    protected JTextField wizardPanel2ESODataPathTextfield;
    protected JGradientButton wizardPanel2ESODataPathButton;
    protected JLabel wizardPanel2ESODataPathDescLabel;
    protected JGradientButton wizardPanel2DetectPathsButton;

    public Wizard(ClientGUI mainGUI) {
        this.mainGUI = mainGUI;
        this.settings = this.mainGUI.getSettings();
        this.lang = this.mainGUI.getLanguageHandler();
        this.initComponents();
        this.setLanguage();
    }

    protected void initComponents() {
        try {
            this.wizardPanel1 = GUIHelper.getPanel(Colors.PANEL_COLOR, null, 0, 0, 860, 600);
            this.wizardPanel2 = GUIHelper.getPanel(Colors.PANEL_COLOR, null, 0, 0, 860, 600);
            this.wizardPanel2.setVisible(false);
            this.wizardPanel1TitleLabel = GUIHelper.getTitleLabel("[wizard_step1_title]", 7, 7, 840, 28);
            this.wizardPanel1TextLabel = GUIHelper.getLabel("[wizard_step1_text]", 0, 14, Colors.TEXT_COLOR_REGULAR);
            this.wizardPanel1TextLabel.setBounds(7, 80, 840, 200);
            this.wizardPanel1TextLabel.setVerticalAlignment(1);
            this.wizardPanel1NextButton = GUIHelper.getGradientButton("[global_next]");
            this.wizardPanel1NextButton.setBounds(690, 520, 140, 32);
            this.wizardPanel1NextButton.setHorizontalTextPosition(2);
            this.wizardPanel1NextButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    Wizard.this.self.showStep(2);
                }
            });
            ResourceHelper.setComponentIcon(this.wizardPanel1NextButton, "chevron-right.png", 17, 17);
            this.wizardPanel2TitleLabel = GUIHelper.getTitleLabel("[wizard_step2_title]", 7, 7, 840, 28);
            this.wizardPanel2TextLabel = GUIHelper.getLabel("[wizard_step2_title]", 0, 14, Colors.TEXT_COLOR_REGULAR);
            this.wizardPanel2TextLabel.setBounds(7, 42, 840, 24);
            this.wizardPanel2TextLabel.setVerticalAlignment(1);
            this.wizardPanel2ErrorLabel = GUIHelper.getLabel("[detect_path_text_fail_wizard]", 0, 14, Colors.BLACK_TEXT_COLOR);
            this.wizardPanel2ErrorLabel.setBackground(Colors.NOTIFICATION_PANEL_COLOR);
            this.wizardPanel2ErrorLabel.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Colors.BORDER_COLOR), new EmptyBorder(2, 4, 2, 4)));
            this.wizardPanel2ErrorLabel.setBounds(7, 245, 840, 36);
            this.wizardPanel2ErrorLabel.setVerticalAlignment(0);
            this.wizardPanel2ErrorLabel.setOpaque(true);
            this.wizardPanel2ErrorLabel.setVisible(false);
            ResourceHelper.setComponentIcon(this.wizardPanel2ErrorLabel, "exclamation-triangle.png", 17, 17);
            this.wizardPanel2BackButton = GUIHelper.getGradientButton("[global_next]");
            this.wizardPanel2BackButton.setBounds(520, 520, 140, 32);
            this.wizardPanel2BackButton.setHorizontalTextPosition(4);
            this.wizardPanel2BackButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    Wizard.this.self.showStep(1);
                }
            });
            ResourceHelper.setComponentIcon(this.wizardPanel2BackButton, "chevron-left.png", 17, 17);
            this.wizardPanel2FinishButton = GUIHelper.getGradientButton("[global_finish]");
            this.wizardPanel2FinishButton.setBounds(690, 520, 140, 32);
            this.wizardPanel2FinishButton.setHorizontalTextPosition(4);
            this.wizardPanel2FinishButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    Wizard.this.self.finish();
                }
            });
            ResourceHelper.setComponentIcon(this.wizardPanel2FinishButton, "check.png", 17, 17);
            this.wizardPanel2ESOTitleLabel = GUIHelper.getTitleLabel("[settings_eso_paths]", 7, 76, 728, 28);
            this.wizardPanel2ESODataPathLabel = GUIHelper.getLabel("[settings_data_dir]", 0, 13);
            this.wizardPanel2ESODataPathLabel.setBounds(12, 108, 728, 18);
            this.wizardPanel2ESODataPathTextfield = GUIHelper.getTextField();
            this.wizardPanel2ESODataPathTextfield.setBounds(12, 130, 540, 29);
            String esoDataDir = Function.getESODataDir();
            if (!esoDataDir.isEmpty()) {
                this.wizardPanel2ESODataPathTextfield.setText(esoDataDir);
                this.self.mainGUI.setDataPath(esoDataDir, true);
            }
            this.wizardPanel2ESODataPathButton = GUIHelper.getGradientButton("[global_browse]");
            this.wizardPanel2ESODataPathButton.setBounds(556, 130, 180, 29);
            this.wizardPanel2ESODataPathButton.setHorizontalAlignment(2);
            this.wizardPanel2ESODataPathButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    String newPath = Function.openFileChooser(Wizard.this.self.mainGUI, 1, Wizard.this.self.lang.getTex("global_choose_directory"), "");
                    if (newPath != null) {
                        Wizard.this.self.wizardPanel2ESODataPathTextfield.setText(newPath);
                        Wizard.this.self.mainGUI.setDataPath(newPath, true);
                    }
                }
            });
            ResourceHelper.setComponentIcon(this.wizardPanel2ESODataPathButton, "folder-open.png", 17, 17);
            this.wizardPanel2ESODataPathDescLabel = GUIHelper.getLabel("[settings_data_dir_default]", 0, 12, Colors.INACTIVE_TEXT_COLOR);
            this.wizardPanel2ESODataPathDescLabel.setBounds(15, 158, 728, 18);
            this.wizardPanel2DetectPathsButton = GUIHelper.getGradientButton("[settings_detect_paths]");
            this.wizardPanel2DetectPathsButton.setBounds(15, 200, 260, 29);
            this.wizardPanel2DetectPathsButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    Wizard.this.self.mainGUI.detectDataPath(false);
                    String path = Wizard.this.self.settings.getValue("ESODataDir");
                    Wizard.this.self.wizardPanel2ErrorLabel.setVisible(path.isEmpty());
                    Wizard.this.self.wizardPanel2ESODataPathTextfield.setText(path);
                }
            });
            ResourceHelper.setComponentIcon(this.wizardPanel2DetectPathsButton, "folder-open.png", 17, 17);
            this.mainGUI.navPanel.setVisible(false);
            this.mainGUI.internetLoadingPanel.setVisible(false);
            this.mainGUI.mainLayeredPanel.add(this.wizardPanel1);
            this.mainGUI.mainLayeredPanel.add(this.wizardPanel2);
            this.wizardPanel1.add(this.wizardPanel1TitleLabel);
            this.wizardPanel1.add(this.wizardPanel1TextLabel);
            this.wizardPanel1.add(this.wizardPanel1NextButton);
            this.wizardPanel2.add(this.wizardPanel2TitleLabel);
            this.wizardPanel2.add(this.wizardPanel2TextLabel);
            this.wizardPanel2.add(this.wizardPanel2ErrorLabel);
            this.wizardPanel2.add(this.wizardPanel2BackButton);
            this.wizardPanel2.add(this.wizardPanel2FinishButton);
            this.wizardPanel2.add(this.wizardPanel2ESOTitleLabel);
            this.wizardPanel2.add(this.wizardPanel2ESODataPathLabel);
            this.wizardPanel2.add(this.wizardPanel2ESODataPathTextfield);
            this.wizardPanel2.add(this.wizardPanel2ESODataPathButton);
            this.wizardPanel2.add(this.wizardPanel2ESODataPathDescLabel);
            this.wizardPanel2.add(this.wizardPanel2DetectPathsButton);
            this.mainGUI.mainLayeredPanel.moveToFront(this.wizardPanel1);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void setLanguage() {
        try {
            String osName;
            this.wizardPanel1TitleLabel.setText(this.lang.getTex("wizard_step1_title"));
            this.wizardPanel1TextLabel.setText(this.lang.getTex("wizard_step1_text"));
            this.wizardPanel2TitleLabel.setText(this.lang.getTex("wizard_step2_title"));
            this.wizardPanel2TextLabel.setText(this.lang.getTex("wizard_step2_text"));
            this.wizardPanel2ErrorLabel.setText(this.lang.getTex("detect_path_text_fail_wizard"));
            this.wizardPanel1NextButton.setText(this.lang.getTex("global_next"));
            this.wizardPanel2FinishButton.setText(this.lang.getTex("global_finish"));
            this.wizardPanel2BackButton.setText(this.lang.getTex("global_back"));
            this.wizardPanel2ESOTitleLabel.setText(this.lang.getTex("settings_eso_paths"));
            this.wizardPanel2ESODataPathLabel.setText(this.lang.getTex("settings_data_dir"));
            this.wizardPanel2ESODataPathButton.setText(this.lang.getTex("global_browse"));
            this.wizardPanel2DetectPathsButton.setText(this.lang.getTex("settings_detect_paths"));
            String wizardDataPathText = switch (osName = Function.getShortOSName()) {
                case "windows" -> this.lang.getTex("settings_data_dir_default_windows");
                case "mac" -> this.lang.getTex("settings_data_dir_default_mac");
                case "linux" -> this.lang.getTex("settings_data_dir_default_linux");
                default -> "";
            };
            this.wizardPanel2ESODataPathDescLabel.setText(wizardDataPathText);
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void showStep(int step) {
        try {
            if (step == 1) {
                this.wizardPanel1.setVisible(true);
                this.wizardPanel2.setVisible(false);
                this.mainGUI.mainLayeredPanel.moveToFront(this.wizardPanel1);
            } else if (step == 2) {
                this.wizardPanel1.setVisible(false);
                this.wizardPanel2.setVisible(true);
                this.mainGUI.mainLayeredPanel.moveToFront(this.wizardPanel2);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void finish() {
        try {
            this.self.mainGUI.setDataPath(this.wizardPanel2ESODataPathTextfield.getText(), true);
            this.mainGUI.setLanguage(true);
            this.mainGUI.initApp(false);
            this.mainGUI.mainLayeredPanel.remove(this.wizardPanel1);
            this.mainGUI.mainLayeredPanel.remove(this.wizardPanel2);
            this.mainGUI.navPanel.setVisible(true);
            this.mainGUI.mainLayeredPanel.moveToFront(this.mainGUI.navPanel);
            this.mainGUI.getNavigationController().setActiveElement(this.mainGUI.navAccountLabel.getName());
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }
}

